/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.state.BackendWritableBroadcastState;
import org.apache.flink.runtime.state.CompressibleFSDataInputStream;
import org.apache.flink.runtime.state.HeapBroadcastState;
import org.apache.flink.runtime.state.OperatorBackendSerializationProxy;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.PartitionableListState;
import org.apache.flink.runtime.state.RegisteredBroadcastStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredOperatorStateBackendMetaInfo;
import org.apache.flink.runtime.state.RestoreOperation;
import org.apache.flink.runtime.state.SnappyStreamCompressionDecorator;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;

public class OperatorStateRestoreOperation
implements RestoreOperation<Void> {
    private final CloseableRegistry closeStreamOnCancelRegistry;
    private final ClassLoader userClassloader;
    private final Map<String, PartitionableListState<?>> registeredOperatorStates;
    private final Map<String, BackendWritableBroadcastState<?, ?>> registeredBroadcastStates;
    private final Collection<OperatorStateHandle> stateHandles;

    public OperatorStateRestoreOperation(CloseableRegistry closeStreamOnCancelRegistry, ClassLoader userClassloader, Map<String, PartitionableListState<?>> registeredOperatorStates, Map<String, BackendWritableBroadcastState<?, ?>> registeredBroadcastStates, @Nonnull Collection<OperatorStateHandle> stateHandles) {
        this.closeStreamOnCancelRegistry = closeStreamOnCancelRegistry;
        this.userClassloader = userClassloader;
        this.registeredOperatorStates = registeredOperatorStates;
        this.registeredBroadcastStates = registeredBroadcastStates;
        this.stateHandles = stateHandles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void restore() throws Exception {
        if (this.stateHandles.isEmpty()) {
            return null;
        }
        for (OperatorStateHandle stateHandle : this.stateHandles) {
            if (stateHandle == null) continue;
            FSDataInputStream in = stateHandle.openInputStream();
            this.closeStreamOnCancelRegistry.registerCloseable((AutoCloseable)in);
            ClassLoader restoreClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.userClassloader);
                OperatorBackendSerializationProxy backendSerializationProxy = new OperatorBackendSerializationProxy(this.userClassloader);
                backendSerializationProxy.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
                List<StateMetaInfoSnapshot> restoredOperatorMetaInfoSnapshots = backendSerializationProxy.getOperatorStateMetaInfoSnapshots();
                for (StateMetaInfoSnapshot stateMetaInfoSnapshot : restoredOperatorMetaInfoSnapshots) {
                    RegisteredOperatorStateBackendMetaInfo restoredMetaInfo = new RegisteredOperatorStateBackendMetaInfo(stateMetaInfoSnapshot);
                    if (restoredMetaInfo.getPartitionStateSerializer() instanceof UnloadableDummyTypeSerializer) {
                        throw new IOException("Unable to restore operator state [" + stateMetaInfoSnapshot.getName() + "]. The previous typeSerializer of the operator state must be present; the typeSerializer could have been removed from the classpath, or its implementation have changed and could not be loaded. This is a temporary restriction that will be fixed in future versions.");
                    }
                    PartitionableListState<Object> listState = this.registeredOperatorStates.get(stateMetaInfoSnapshot.getName());
                    if (null != listState) continue;
                    listState = new PartitionableListState(restoredMetaInfo);
                    this.registeredOperatorStates.put(listState.getStateMetaInfo().getName(), listState);
                }
                List<StateMetaInfoSnapshot> restoredBroadcastMetaInfoSnapshots = backendSerializationProxy.getBroadcastStateMetaInfoSnapshots();
                for (StateMetaInfoSnapshot restoredSnapshot3 : restoredBroadcastMetaInfoSnapshots) {
                    RegisteredBroadcastStateBackendMetaInfo restoredMetaInfo = new RegisteredBroadcastStateBackendMetaInfo(restoredSnapshot3);
                    if (restoredMetaInfo.getKeySerializer() instanceof UnloadableDummyTypeSerializer || restoredMetaInfo.getValueSerializer() instanceof UnloadableDummyTypeSerializer) {
                        throw new IOException("Unable to restore broadcast state [" + restoredSnapshot3.getName() + "]. The previous key and value serializers of the state must be present; the serializers could have been removed from the classpath, or their implementations have changed and could not be loaded. This is a temporary restriction that will be fixed in future versions.");
                    }
                    BackendWritableBroadcastState<?, ?> broadcastState = this.registeredBroadcastStates.get(restoredSnapshot3.getName());
                    if (broadcastState != null) continue;
                    broadcastState = new HeapBroadcastState(restoredMetaInfo);
                    this.registeredBroadcastStates.put(broadcastState.getStateMetaInfo().getName(), broadcastState);
                }
                ArrayList arrayList = new ArrayList();
                restoredOperatorMetaInfoSnapshots.forEach(stateName -> toRestore.add(stateName.getName()));
                restoredBroadcastMetaInfoSnapshots.forEach(stateName -> toRestore.add(stateName.getName()));
                StreamCompressionDecorator compressionDecorator = backendSerializationProxy.isUsingStateCompression() ? SnappyStreamCompressionDecorator.INSTANCE : UncompressedStreamCompressionDecorator.INSTANCE;
                CompressibleFSDataInputStream compressedIn = new CompressibleFSDataInputStream(in, compressionDecorator);
                Throwable throwable = null;
                try {
                    for (String stateName2 : arrayList) {
                        OperatorStateHandle.StateMetaInfo offsets = stateHandle.getStateNameToPartitionOffsets().get(stateName2);
                        PartitionableListState<?> listStateForName = this.registeredOperatorStates.get(stateName2);
                        if (listStateForName == null) {
                            BackendWritableBroadcastState<?, ?> broadcastStateForName = this.registeredBroadcastStates.get(stateName2);
                            Preconditions.checkState((broadcastStateForName != null ? 1 : 0) != 0, (Object)("Found state without corresponding meta info: " + stateName2));
                            this.deserializeBroadcastStateValues(broadcastStateForName, compressedIn, offsets);
                            continue;
                        }
                        this.deserializeOperatorStateValues(listStateForName, compressedIn, offsets);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (compressedIn == null) continue;
                    if (throwable != null) {
                        try {
                            compressedIn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    compressedIn.close();
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(restoreClassLoader);
                if (!this.closeStreamOnCancelRegistry.unregisterCloseable((AutoCloseable)in)) continue;
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        return null;
    }

    private <S> void deserializeOperatorStateValues(PartitionableListState<S> stateListForName, FSDataInputStream in, OperatorStateHandle.StateMetaInfo metaInfo) throws IOException {
        long[] offsets;
        if (null != metaInfo && null != (offsets = metaInfo.getOffsets())) {
            DataInputViewStreamWrapper div = new DataInputViewStreamWrapper((InputStream)in);
            TypeSerializer<S> serializer = stateListForName.getStateMetaInfo().getPartitionStateSerializer();
            for (long offset : offsets) {
                in.seek(offset);
                stateListForName.add(serializer.deserialize((DataInputView)div));
            }
        }
    }

    private <K, V> void deserializeBroadcastStateValues(BackendWritableBroadcastState<K, V> broadcastStateForName, FSDataInputStream in, OperatorStateHandle.StateMetaInfo metaInfo) throws Exception {
        long[] offsets;
        if (metaInfo != null && (offsets = metaInfo.getOffsets()) != null) {
            TypeSerializer<K> keySerializer = broadcastStateForName.getStateMetaInfo().getKeySerializer();
            TypeSerializer<V> valueSerializer = broadcastStateForName.getStateMetaInfo().getValueSerializer();
            in.seek(offsets[0]);
            DataInputViewStreamWrapper div = new DataInputViewStreamWrapper((InputStream)in);
            int size = div.readInt();
            for (int i = 0; i < size; ++i) {
                broadcastStateForName.put(keySerializer.deserialize((DataInputView)div), valueSerializer.deserialize((DataInputView)div));
            }
        }
    }
}

