/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystemLoader;
import org.apache.flink.runtime.rpc.RpcSystemUtils;
import org.apache.flink.runtime.rpc.exceptions.RpcLoaderException;
import org.apache.flink.util.ExceptionUtils;

public interface RpcSystem
extends RpcSystemUtils,
AutoCloseable {
    public RpcServiceBuilder localServiceBuilder(Configuration var1);

    public RpcServiceBuilder remoteServiceBuilder(Configuration var1, @Nullable String var2, String var3);

    @Override
    default public void close() {
    }

    public static RpcSystem load() {
        return RpcSystem.load(new Configuration());
    }

    public static RpcSystem load(Configuration config) {
        PriorityQueue<RpcSystemLoader> rpcSystemLoaders = new PriorityQueue<RpcSystemLoader>(Comparator.comparingInt(RpcSystemLoader::getLoadPriority));
        ServiceLoader.load(RpcSystemLoader.class).forEach(rpcSystemLoaders::add);
        Iterator<RpcSystemLoader> iterator = rpcSystemLoaders.iterator();
        Exception loadError = null;
        while (iterator.hasNext()) {
            RpcSystemLoader next = iterator.next();
            try {
                return next.loadRpcSystem(config);
            }
            catch (Exception e) {
                loadError = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, loadError);
            }
        }
        throw new RpcLoaderException("Could not load RpcSystem.", loadError);
    }

    public static class FixedThreadPoolExecutorConfiguration {
        private final int minNumThreads;
        private final int maxNumThreads;
        private final int threadPriority;

        public FixedThreadPoolExecutorConfiguration(int minNumThreads, int maxNumThreads, int threadPriority) {
            if (threadPriority < 1 || threadPriority > 10) {
                throw new IllegalArgumentException(String.format("The thread priority must be within (%s, %s) but it was %s.", 1, 10, threadPriority));
            }
            this.minNumThreads = minNumThreads;
            this.maxNumThreads = maxNumThreads;
            this.threadPriority = threadPriority;
        }

        public int getMinNumThreads() {
            return this.minNumThreads;
        }

        public int getMaxNumThreads() {
            return this.maxNumThreads;
        }

        public int getThreadPriority() {
            return this.threadPriority;
        }
    }

    public static class ForkJoinExecutorConfiguration {
        private final double parallelismFactor;
        private final int minParallelism;
        private final int maxParallelism;

        public ForkJoinExecutorConfiguration(double parallelismFactor, int minParallelism, int maxParallelism) {
            this.parallelismFactor = parallelismFactor;
            this.minParallelism = minParallelism;
            this.maxParallelism = maxParallelism;
        }

        public double getParallelismFactor() {
            return this.parallelismFactor;
        }

        public int getMinParallelism() {
            return this.minParallelism;
        }

        public int getMaxParallelism() {
            return this.maxParallelism;
        }
    }

    public static interface RpcServiceBuilder {
        public RpcServiceBuilder withComponentName(String var1);

        public RpcServiceBuilder withBindAddress(String var1);

        public RpcServiceBuilder withBindPort(int var1);

        public RpcServiceBuilder withExecutorConfiguration(FixedThreadPoolExecutorConfiguration var1);

        public RpcServiceBuilder withExecutorConfiguration(ForkJoinExecutorConfiguration var1);

        public RpcService createAndStart() throws Exception;
    }
}

