/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess;

import io.github.spannm.jackcess.Database;
import io.github.spannm.jackcess.JackcessException;
import io.github.spannm.jackcess.impl.DatabaseImpl;
import io.github.spannm.jackcess.impl.JetFormat;
import io.github.spannm.jackcess.impl.SqlHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public enum DataType {
    BOOLEAN(1, "Bit", 16, 0),
    BYTE(2, "Byte", -6, 1),
    INT(3, "Short", 5, 2),
    LONG(4, "Long", 4, 4),
    MONEY(5, "Currency", 3, 8, false, false, 0, 0, 0, false, 4, 4, 4, 19, 19, 19, 1),
    FLOAT(6, "IEEESingle", 6, 4),
    DOUBLE(7, "IEEEDouble", 8, 8),
    SHORT_DATE_TIME(8, "DateTime", 93, 8),
    BINARY(9, "Binary", -2, null, true, false, 0, 255, 255, 1),
    TEXT(10, "Text", 12, null, true, false, 0, 510, 510, 2),
    OLE(11, "LongBinary", -4, null, true, true, 0, 0, 0x3FFFFFFF, 1),
    MEMO(12, null, -1, null, true, true, 0, 0, 0x3FFFFFFF, 2),
    UNKNOWN_0D(13, null, null, null, true, false, 0, 255, 255, 1),
    GUID(15, "Guid", null, 16),
    NUMERIC(16, null, 2, 17, true, false, 17, 17, 17, true, 0, 0, 28, 1, 18, 28, 1),
    UNKNOWN_11(17, "TYPENAME", null, 3992),
    COMPLEX_TYPE(18, "TYPENAME", null, 4),
    BIG_INT(19, "TYPENAME", -5, 8),
    EXT_DATE_TIME(20, "TYPENAME", null, 42),
    UNSUPPORTED_FIXEDLEN(-2, "TYPENAME", null, null),
    UNSUPPORTED_VARLEN(-1, null, null, null, true, false, 0, 0, 0x3FFFFFFF, 1);

    private static final Map<Integer, DataType[]> SQL_TYPES;
    private static final Map<Integer, DataType> ALT_SQL_TYPES;
    private static final Map<Byte, DataType> DATA_TYPES_BY_VALUE;
    private final boolean _variableLength;
    private final boolean _longValue;
    private final boolean _hasScalePrecision;
    private final byte _value;
    private final String _typeName;
    private final Integer _fixedSize;
    private final int _minSize;
    private final int _defaultSize;
    private final int _maxSize;
    private final Integer _sqlType;
    private final int _minScale;
    private final int _defaultScale;
    private final int _maxScale;
    private final int _minPrecision;
    private final int _defaultPrecision;
    private final int _maxPrecision;
    private final int _unitSize;

    private DataType(byte value, String typeName, Integer sqlType, Integer fixedSize) {
        this(value, typeName, sqlType, fixedSize, false, false, 0, 0, 0, 1);
    }

    private DataType(byte value, String typeName, Integer sqlType, Integer fixedSize, boolean variableLength, boolean longValue, int minSize, int defaultSize, int maxSize, int unitSize) {
        this(value, typeName, sqlType, fixedSize, variableLength, longValue, minSize, defaultSize, maxSize, false, 0, 0, 0, 0, 0, 0, unitSize);
    }

    private DataType(byte value, String typeName, Integer sqlType, Integer fixedSize, boolean variableLength, boolean longValue, int minSize, int defaultSize, int maxSize, boolean hasScalePrecision, int minScale, int defaultScale, int maxScale, int minPrecision, int defaultPrecision, int maxPrecision, int unitSize) {
        this._value = value;
        this._typeName = typeName;
        this._sqlType = sqlType;
        this._fixedSize = fixedSize;
        this._variableLength = variableLength;
        this._longValue = longValue;
        this._minSize = minSize;
        this._defaultSize = defaultSize;
        this._maxSize = maxSize;
        this._hasScalePrecision = hasScalePrecision;
        this._minScale = minScale;
        this._defaultScale = defaultScale;
        this._maxScale = maxScale;
        this._minPrecision = minPrecision;
        this._defaultPrecision = defaultPrecision;
        this._maxPrecision = maxPrecision;
        this._unitSize = unitSize;
    }

    public byte getValue() {
        return this._value;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public boolean isVariableLength() {
        return this._variableLength;
    }

    public boolean isTrueVariableLength() {
        return this.isVariableLength() && this.getMinSize() != this.getMaxSize();
    }

    public boolean isLongValue() {
        return this._longValue;
    }

    public boolean getHasScalePrecision() {
        return this._hasScalePrecision;
    }

    public int getFixedSize() {
        return this.getFixedSize(null);
    }

    public int getFixedSize(Short colLength) {
        if (this._fixedSize != null) {
            if (colLength != null) {
                return Math.max(this._fixedSize, colLength.shortValue());
            }
            return this._fixedSize;
        }
        if (colLength != null) {
            return colLength.shortValue();
        }
        throw new IllegalArgumentException("Unexpected fixed length column " + this);
    }

    public int getMinSize() {
        return this._minSize;
    }

    public int getDefaultSize() {
        return this._defaultSize;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public int getSQLType() throws IOException {
        if (this._sqlType != null) {
            return this._sqlType;
        }
        throw new JackcessException("Unsupported data type: " + this);
    }

    public int getMinScale() {
        return this._minScale;
    }

    public int getDefaultScale() {
        return this._defaultScale;
    }

    public int getMaxScale() {
        return this._maxScale;
    }

    public int getMinPrecision() {
        return this._minPrecision;
    }

    public int getDefaultPrecision() {
        return this._defaultPrecision;
    }

    public int getMaxPrecision() {
        return this._maxPrecision;
    }

    public int getUnitSize() {
        return this._unitSize;
    }

    public int getUnitSize(JetFormat format) {
        if (format != null && this.isTextual()) {
            return format.SIZE_TEXT_FIELD_UNIT;
        }
        return this._unitSize;
    }

    public int toUnitSize(int size) {
        return this.toUnitSize(size, null);
    }

    public int toUnitSize(int size, JetFormat format) {
        return size / this.getUnitSize(format);
    }

    public int fromUnitSize(int unitSize) {
        return this.fromUnitSize(unitSize, null);
    }

    public int fromUnitSize(int unitSize, JetFormat format) {
        return unitSize * this.getUnitSize(format);
    }

    public boolean isValidSize(int size) {
        return DataType.isWithinRange(size, this.getMinSize(), this.getMaxSize());
    }

    public boolean isValidScale(int scale) {
        return DataType.isWithinRange(scale, this.getMinScale(), this.getMaxScale());
    }

    public boolean isValidPrecision(int precision) {
        return DataType.isWithinRange(precision, this.getMinPrecision(), this.getMaxPrecision());
    }

    private static boolean isWithinRange(int value, int minValue, int maxValue) {
        return value >= minValue && value <= maxValue;
    }

    public int toValidSize(int size) {
        return DataType.toValidRange(size, this.getMinSize(), this.getMaxSize());
    }

    public int toValidScale(int scale) {
        return DataType.toValidRange(scale, this.getMinScale(), this.getMaxScale());
    }

    public int toValidPrecision(int precision) {
        return DataType.toValidRange(precision, this.getMinPrecision(), this.getMaxPrecision());
    }

    public boolean isTextual() {
        return this == TEXT || this == MEMO;
    }

    public boolean mayBeAutoNumber() {
        return this == LONG || this == GUID || this == COMPLEX_TYPE;
    }

    public boolean isMultipleAutoNumberAllowed() {
        return this == COMPLEX_TYPE;
    }

    public boolean isSupported() {
        return this != UNSUPPORTED_FIXEDLEN && this != UNSUPPORTED_VARLEN;
    }

    private static int toValidRange(int value, int minValue, int maxValue) {
        return value > maxValue ? maxValue : Math.max(value, minValue);
    }

    public static DataType fromByte(byte b) throws IOException {
        DataType rtn = DATA_TYPES_BY_VALUE.get(b);
        if (rtn != null) {
            return rtn;
        }
        throw new IOException("Unrecognized data type: " + b);
    }

    public static String getTypeName(short value) {
        if (value == 0) {
            return "Value";
        }
        DataType dt = DATA_TYPES_BY_VALUE.get((byte)value);
        return dt == null ? null : dt.getTypeName();
    }

    public static DataType fromSQLType(int sqlType) throws IOException {
        return DataType.fromSQLType(sqlType, 0, null);
    }

    public static DataType fromSQLType(int sqlType, int lengthInUnits) throws IOException {
        return DataType.fromSQLType(sqlType, lengthInUnits, null);
    }

    public static DataType fromSQLType(int sqlType, int lengthInUnits, Database.FileFormat fileFormat) throws IOException {
        DataType altRtn;
        DataType[] rtnArr = SQL_TYPES.get(sqlType);
        if (rtnArr == null) {
            throw new JackcessException("Unsupported SQL type: " + sqlType);
        }
        JetFormat format = fileFormat != null ? DatabaseImpl.getFileFormatDetails(fileFormat).getFormat() : null;
        DataType rtn = rtnArr[0];
        if (rtnArr.length > 1 && format != null) {
            for (int i = rtnArr.length - 1; i >= 0; --i) {
                DataType tmp = rtnArr[i];
                if (!format.isSupportedDataType(tmp)) continue;
                rtn = tmp;
                break;
            }
        }
        int size = rtn.fromUnitSize(lengthInUnits, format);
        if (rtn.isVariableLength() && !rtn.isValidSize(size) && (altRtn = ALT_SQL_TYPES.get(sqlType)) != null && (altRtn.isLongValue() || altRtn.isValidSize(size))) {
            rtn = altRtn;
        }
        return rtn;
    }

    private static void addNewSqlType(String typeName, DataType type, DataType altType) {
        try {
            Integer value = SqlHelper.INSTANCE.getNewSqlType(typeName);
            SQL_TYPES.put(value, new DataType[]{type});
            if (altType != null) {
                ALT_SQL_TYPES.put(value, altType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        SQL_TYPES = new HashMap<Integer, DataType[]>();
        ALT_SQL_TYPES = new HashMap<Integer, DataType>();
        for (DataType type : DataType.values()) {
            if (type._sqlType == null) continue;
            SQL_TYPES.put(type._sqlType, new DataType[]{type});
        }
        SQL_TYPES.put(-7, new DataType[]{BYTE});
        SQL_TYPES.put(2004, new DataType[]{OLE});
        SQL_TYPES.put(2005, new DataType[]{MEMO});
        SQL_TYPES.put(-5, new DataType[]{LONG, BIG_INT});
        SQL_TYPES.put(1, new DataType[]{TEXT});
        SQL_TYPES.put(91, new DataType[]{SHORT_DATE_TIME});
        SQL_TYPES.put(7, new DataType[]{DOUBLE});
        SQL_TYPES.put(92, new DataType[]{SHORT_DATE_TIME});
        SQL_TYPES.put(-3, new DataType[]{BINARY});
        ALT_SQL_TYPES.put(12, MEMO);
        ALT_SQL_TYPES.put(-3, OLE);
        ALT_SQL_TYPES.put(-2, OLE);
        DataType.addNewSqlType("NCHAR", TEXT, null);
        DataType.addNewSqlType("NVARCHAR", TEXT, MEMO);
        DataType.addNewSqlType("LONGNVARCHAR", MEMO, null);
        DataType.addNewSqlType("NCLOB", MEMO, null);
        DataType.addNewSqlType("TIME_WITH_TIMEZONE", SHORT_DATE_TIME, null);
        DataType.addNewSqlType("TIMESTAMP_WITH_TIMEZONE", SHORT_DATE_TIME, null);
        DATA_TYPES_BY_VALUE = Arrays.stream(DataType.values()).filter(DataType::isSupported).collect(Collectors.toMap(k -> k._value, v -> v));
    }
}

