/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.model;

import java.util.List;
import java.util.ListIterator;
import org.apache.hop.neo4j.model.AreaType;

public class AreaOwner {
    private int x;
    private int y;
    private int width;
    private int height;
    private AreaType areaType;
    private Object subject;

    public AreaOwner() {
    }

    public AreaOwner(int x, int y, int width, int height, AreaType areaType, Object subject) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.areaType = areaType;
        this.subject = subject;
    }

    public static final AreaOwner findArea(List<AreaOwner> areaOwners, int x, int y) {
        ListIterator<AreaOwner> li = areaOwners.listIterator(areaOwners.size());
        while (li.hasPrevious()) {
            AreaOwner areaOwner = li.previous();
            if (!areaOwner.contains(x, y)) continue;
            return areaOwner;
        }
        return null;
    }

    private boolean contains(int locX, int locY) {
        return locX >= this.x && locY >= this.y && locX <= this.x + this.width && locY <= this.y + this.height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
    }

    public Object getSubject() {
        return this.subject;
    }

    public void setSubject(Object subject) {
        this.subject = subject;
    }
}

