/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocket;
import org.apache.flink.shaded.zookeeper3.org.apache.jute.BinaryInputArchive;
import org.apache.flink.shaded.zookeeper3.org.apache.jute.BinaryOutputArchive;
import org.apache.flink.shaded.zookeeper3.org.apache.jute.InputArchive;
import org.apache.flink.shaded.zookeeper3.org.apache.jute.OutputArchive;
import org.apache.flink.shaded.zookeeper3.org.apache.jute.Record;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.common.Time;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.common.X509Exception;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.ExitCode;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.Request;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.ServerCnxn;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.ServerMetrics;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.TxnLogEntry;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.ZooTrace;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.LearnerInfo;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.LearnerSender;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.MultipleAddresses;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.Vote;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.util.ConfigUtils;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.util.MessageTracker;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.util.ZxidUtils;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.txn.SetDataTxn;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.txn.TxnDigest;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.txn.TxnHeader;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.util.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Learner {
    QuorumPeer self;
    LearnerZooKeeperServer zk;
    protected BufferedOutputStream bufferedOutput;
    protected Socket sock;
    protected MultipleAddresses leaderAddr;
    protected AtomicBoolean sockBeingClosed = new AtomicBoolean(false);
    LearnerSender sender = null;
    protected InputArchive leaderIs;
    protected OutputArchive leaderOs;
    protected int leaderProtocolVersion = 1;
    private static final int BUFFERED_MESSAGE_SIZE = 10;
    protected final MessageTracker messageTracker = new MessageTracker(10);
    protected static final Logger LOG = LoggerFactory.getLogger(Learner.class);
    private static final int leaderConnectDelayDuringRetryMs = Integer.getInteger("zookeeper.leaderConnectDelayDuringRetryMs", 100);
    private static final boolean nodelay = System.getProperty("follower.nodelay", "true").equals("true");
    public static final String LEARNER_ASYNC_SENDING = "zookeeper.learner.asyncSending";
    private static boolean asyncSending = Boolean.parseBoolean(ConfigUtils.getPropertyBackwardCompatibleWay("zookeeper.learner.asyncSending"));
    public static final String LEARNER_CLOSE_SOCKET_ASYNC = "zookeeper.learner.closeSocketAsync";
    public static final boolean closeSocketAsync = Boolean.parseBoolean(ConfigUtils.getPropertyBackwardCompatibleWay("zookeeper.learner.closeSocketAsync"));
    final ConcurrentHashMap<Long, ServerCnxn> pendingRevalidations = new ConcurrentHashMap();

    public Socket getSocket() {
        return this.sock;
    }

    public int getPendingRevalidationsCount() {
        return this.pendingRevalidations.size();
    }

    protected static void setAsyncSending(boolean newMode) {
        asyncSending = newMode;
        LOG.info("{} = {}", (Object)LEARNER_ASYNC_SENDING, (Object)asyncSending);
    }

    protected static boolean getAsyncSending() {
        return asyncSending;
    }

    void validateSession(ServerCnxn cnxn, long clientId, int timeout) throws IOException {
        LOG.info("Revalidating client: 0x{}", (Object)Long.toHexString(clientId));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeLong(clientId);
        dos.writeInt(timeout);
        dos.close();
        QuorumPacket qp = new QuorumPacket(6, -1L, baos.toByteArray(), null);
        this.pendingRevalidations.put(clientId, cnxn);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "To validate session 0x" + Long.toHexString(clientId));
        }
        this.writePacket(qp, true);
    }

    void writePacket(QuorumPacket pp, boolean flush) throws IOException {
        if (asyncSending) {
            this.sender.queuePacket(pp);
        } else {
            this.writePacketNow(pp, flush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePacketNow(QuorumPacket pp, boolean flush) throws IOException {
        OutputArchive outputArchive = this.leaderOs;
        synchronized (outputArchive) {
            if (pp != null) {
                this.messageTracker.trackSent(pp.getType());
                this.leaderOs.writeRecord(pp, "packet");
            }
            if (flush) {
                this.bufferedOutput.flush();
            }
        }
    }

    protected void startSendingThread() {
        this.sender = new LearnerSender(this);
        this.sender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readPacket(QuorumPacket pp) throws IOException {
        InputArchive inputArchive = this.leaderIs;
        synchronized (inputArchive) {
            this.leaderIs.readRecord(pp, "packet");
            this.messageTracker.trackReceived(pp.getType());
        }
        if (LOG.isTraceEnabled()) {
            long traceMask = pp.getType() == 5 ? 128L : 16L;
            ZooTrace.logQuorumPacket(LOG, traceMask, 'i', pp);
        }
    }

    void request(Request request) throws IOException {
        if (request.isThrottled()) {
            LOG.error("Throttled request sent to leader: {}. Exiting", (Object)request);
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream oa = new DataOutputStream(baos);
        oa.writeLong(request.sessionId);
        oa.writeInt(request.cxid);
        oa.writeInt(request.type);
        if (request.request != null) {
            request.request.rewind();
            int len = request.request.remaining();
            byte[] b = new byte[len];
            request.request.get(b);
            request.request.rewind();
            oa.write(b);
        }
        oa.close();
        QuorumPacket qp = new QuorumPacket(1, -1L, baos.toByteArray(), request.authInfo);
        this.writePacket(qp, true);
    }

    protected QuorumPeer.QuorumServer findLeader() {
        QuorumPeer.QuorumServer leaderServer = null;
        Vote current = this.self.getCurrentVote();
        for (QuorumPeer.QuorumServer s : this.self.getView().values()) {
            if (s.id != current.getId()) continue;
            s.recreateSocketAddresses();
            leaderServer = s;
            break;
        }
        if (leaderServer == null) {
            LOG.warn("Couldn't find the leader with id = {}", (Object)current.getId());
        }
        return leaderServer;
    }

    protected long nanoTime() {
        return System.nanoTime();
    }

    protected void sockConnect(Socket sock, InetSocketAddress addr, int timeout) throws IOException {
        sock.connect(addr, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToLeader(MultipleAddresses multiAddr, String hostname) throws IOException {
        this.leaderAddr = multiAddr;
        Set<InetSocketAddress> addresses = this.self.isMultiAddressReachabilityCheckEnabled() ? multiAddr.getAllReachableAddressesOrAll() : multiAddr.getAllAddresses();
        ExecutorService executor = Executors.newFixedThreadPool(addresses.size());
        CountDownLatch latch = new CountDownLatch(addresses.size());
        AtomicReference<Object> socket = new AtomicReference<Object>(null);
        addresses.stream().map(address -> new LeaderConnector((InetSocketAddress)address, (AtomicReference<Socket>)socket, latch)).forEach(executor::submit);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while trying to connect to Leader", (Throwable)e);
        }
        finally {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    LOG.error("not all the LeaderConnector terminated properly");
                }
            }
            catch (InterruptedException ie) {
                LOG.error("Interrupted while terminating LeaderConnector executor.", (Throwable)ie);
            }
        }
        if (socket.get() == null) {
            throw new IOException("Failed connect to " + multiAddr);
        }
        this.sock = socket.get();
        this.sockBeingClosed.set(false);
        this.self.authLearner.authenticate(this.sock, hostname);
        this.leaderIs = BinaryInputArchive.getArchive(new BufferedInputStream(this.sock.getInputStream()));
        this.bufferedOutput = new BufferedOutputStream(this.sock.getOutputStream());
        this.leaderOs = BinaryOutputArchive.getArchive(this.bufferedOutput);
        if (asyncSending) {
            this.startSendingThread();
        }
    }

    protected Socket createSocket() throws X509Exception, IOException {
        Socket sock = this.self.isSslQuorum() ? this.self.getX509Util().createSSLSocket() : new Socket();
        sock.setSoTimeout(this.self.tickTime * this.self.initLimit);
        return sock;
    }

    protected long registerWithLeader(int pktType) throws IOException {
        long lastLoggedZxid = this.self.getLastLoggedZxid();
        QuorumPacket qp = new QuorumPacket();
        qp.setType(pktType);
        qp.setZxid(ZxidUtils.makeZxid(this.self.getAcceptedEpoch(), 0L));
        LearnerInfo li = new LearnerInfo(this.self.getId(), 65536, this.self.getQuorumVerifier().getVersion());
        ByteArrayOutputStream bsid = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(bsid);
        boa.writeRecord(li, "LearnerInfo");
        qp.setData(bsid.toByteArray());
        this.writePacket(qp, true);
        this.readPacket(qp);
        long newEpoch = ZxidUtils.getEpochFromZxid(qp.getZxid());
        if (qp.getType() == 17) {
            this.leaderProtocolVersion = ByteBuffer.wrap(qp.getData()).getInt();
            byte[] epochBytes = new byte[4];
            ByteBuffer wrappedEpochBytes = ByteBuffer.wrap(epochBytes);
            if (newEpoch > this.self.getAcceptedEpoch()) {
                wrappedEpochBytes.putInt((int)this.self.getCurrentEpoch());
                this.self.setAcceptedEpoch(newEpoch);
            } else if (newEpoch == this.self.getAcceptedEpoch()) {
                wrappedEpochBytes.putInt(-1);
            } else {
                throw new IOException("Leaders epoch, " + newEpoch + " is less than accepted epoch, " + this.self.getAcceptedEpoch());
            }
            QuorumPacket ackNewEpoch = new QuorumPacket(18, lastLoggedZxid, epochBytes, null);
            this.writePacket(ackNewEpoch, true);
            return ZxidUtils.makeZxid(newEpoch, 0L);
        }
        if (newEpoch > this.self.getAcceptedEpoch()) {
            this.self.setAcceptedEpoch(newEpoch);
        }
        if (qp.getType() != 10) {
            LOG.error("First packet should have been NEWLEADER");
            throw new IOException("First packet should have been NEWLEADER");
        }
        return qp.getZxid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void syncWithLeader(long newLeaderZxid) throws Exception {
        QuorumPacket ack = new QuorumPacket(3, 0L, null, null);
        QuorumPacket qp = new QuorumPacket();
        long newEpoch = ZxidUtils.getEpochFromZxid(newLeaderZxid);
        QuorumVerifier newLeaderQV = null;
        boolean snapshotNeeded = true;
        boolean syncSnapshot = false;
        this.readPacket(qp);
        ArrayDeque<Long> packetsCommitted = new ArrayDeque<Long>();
        ArrayDeque<PacketInFlight> packetsNotCommitted = new ArrayDeque<PacketInFlight>();
        LearnerZooKeeperServer learnerZooKeeperServer = this.zk;
        synchronized (learnerZooKeeperServer) {
            boolean writeToTxnLog;
            if (qp.getType() == 13) {
                LOG.info("Getting a diff from the leader 0x{}", (Object)Long.toHexString(qp.getZxid()));
                this.self.setSyncMode(QuorumPeer.SyncMode.DIFF);
                if (this.zk.shouldForceWriteInitialSnapshotAfterLeaderElection()) {
                    LOG.info("Forcing a snapshot write as part of upgrading from an older Zookeeper. This should only happen while upgrading.");
                    snapshotNeeded = true;
                    syncSnapshot = true;
                } else {
                    snapshotNeeded = false;
                }
            } else if (qp.getType() == 15) {
                String signature;
                this.self.setSyncMode(QuorumPeer.SyncMode.SNAP);
                LOG.info("Getting a snapshot from leader 0x{}", (Object)Long.toHexString(qp.getZxid()));
                this.zk.getZKDatabase().deserializeSnapshot(this.leaderIs);
                if (!this.self.isReconfigEnabled()) {
                    LOG.debug("Reset config node content from local config after deserialization of snapshot.");
                    this.zk.getZKDatabase().initConfigInZKDatabase(this.self.getQuorumVerifier());
                }
                if (!(signature = this.leaderIs.readString("signature")).equals("BenWasHere")) {
                    LOG.error("Missing signature. Got {}", (Object)signature);
                    throw new IOException("Missing signature");
                }
                this.zk.getZKDatabase().setlastProcessedZxid(qp.getZxid());
                syncSnapshot = true;
            } else if (qp.getType() == 14) {
                this.self.setSyncMode(QuorumPeer.SyncMode.TRUNC);
                LOG.warn("Truncating log to get in sync with the leader 0x{}", (Object)Long.toHexString(qp.getZxid()));
                boolean truncated = this.zk.getZKDatabase().truncateLog(qp.getZxid());
                if (!truncated) {
                    LOG.error("Not able to truncate the log 0x{}", (Object)Long.toHexString(qp.getZxid()));
                    ServiceUtils.requestSystemExit(ExitCode.QUORUM_PACKET_ERROR.getValue());
                }
                this.zk.getZKDatabase().setlastProcessedZxid(qp.getZxid());
            } else {
                LOG.error("Got unexpected packet from leader: {}, exiting ... ", (Object)LearnerHandler.packetToString(qp));
                ServiceUtils.requestSystemExit(ExitCode.QUORUM_PACKET_ERROR.getValue());
            }
            this.zk.getZKDatabase().initConfigInZKDatabase(this.self.getQuorumVerifier());
            this.zk.createSessionTracker();
            long lastQueued = 0L;
            boolean isPreZAB1_0 = true;
            boolean bl = writeToTxnLog = !snapshotNeeded;
            block11: while (this.self.isRunning()) {
                this.readPacket(qp);
                switch (qp.getType()) {
                    case 2: {
                        QuorumVerifier qv;
                        PacketInFlight pif = new PacketInFlight();
                        TxnLogEntry logEntry = SerializeUtils.deserializeTxn(qp.getData());
                        pif.hdr = logEntry.getHeader();
                        pif.rec = logEntry.getTxn();
                        pif.digest = logEntry.getDigest();
                        if (pif.hdr.getZxid() != lastQueued + 1L) {
                            LOG.warn("Got zxid 0x{} expected 0x{}", (Object)Long.toHexString(pif.hdr.getZxid()), (Object)Long.toHexString(lastQueued + 1L));
                        }
                        lastQueued = pif.hdr.getZxid();
                        if (pif.hdr.getType() == 16) {
                            SetDataTxn setDataTxn = (SetDataTxn)pif.rec;
                            qv = this.self.configFromString(new String(setDataTxn.getData(), StandardCharsets.UTF_8));
                            this.self.setLastSeenQuorumVerifier(qv, true);
                        }
                        packetsNotCommitted.add(pif);
                        break;
                    }
                    case 4: 
                    case 9: {
                        QuorumVerifier qv;
                        boolean majorChange;
                        PacketInFlight pif = (PacketInFlight)packetsNotCommitted.peekFirst();
                        if (pif.hdr.getZxid() == qp.getZxid() && qp.getType() == 9 && (majorChange = this.self.processReconfig(qv = this.self.configFromString(new String(((SetDataTxn)pif.rec).getData(), StandardCharsets.UTF_8)), ByteBuffer.wrap(qp.getData()).getLong(), qp.getZxid(), true))) {
                            throw new Exception("changes proposed in reconfig");
                        }
                        if (!writeToTxnLog) {
                            if (pif.hdr.getZxid() != qp.getZxid()) {
                                LOG.warn("Committing 0x{}, but next proposal is 0x{}", (Object)Long.toHexString(qp.getZxid()), (Object)Long.toHexString(pif.hdr.getZxid()));
                                break;
                            }
                            this.zk.processTxn(pif.hdr, pif.rec);
                            packetsNotCommitted.remove();
                            break;
                        }
                        packetsCommitted.add(qp.getZxid());
                        break;
                    }
                    case 8: 
                    case 19: {
                        TxnLogEntry logEntry;
                        PacketInFlight packet = new PacketInFlight();
                        if (qp.getType() == 19) {
                            ByteBuffer buffer = ByteBuffer.wrap(qp.getData());
                            long suggestedLeaderId = buffer.getLong();
                            byte[] remainingdata = new byte[buffer.remaining()];
                            buffer.get(remainingdata);
                            logEntry = SerializeUtils.deserializeTxn(remainingdata);
                            packet.hdr = logEntry.getHeader();
                            packet.rec = logEntry.getTxn();
                            packet.digest = logEntry.getDigest();
                            QuorumVerifier qv = this.self.configFromString(new String(((SetDataTxn)packet.rec).getData(), StandardCharsets.UTF_8));
                            boolean majorChange = this.self.processReconfig(qv, suggestedLeaderId, qp.getZxid(), true);
                            if (majorChange) {
                                throw new Exception("changes proposed in reconfig");
                            }
                        } else {
                            logEntry = SerializeUtils.deserializeTxn(qp.getData());
                            packet.rec = logEntry.getTxn();
                            packet.hdr = logEntry.getHeader();
                            packet.digest = logEntry.getDigest();
                            if (packet.hdr.getZxid() != lastQueued + 1L) {
                                LOG.warn("Got zxid 0x{} expected 0x{}", (Object)Long.toHexString(packet.hdr.getZxid()), (Object)Long.toHexString(lastQueued + 1L));
                            }
                            lastQueued = packet.hdr.getZxid();
                        }
                        if (!writeToTxnLog) {
                            this.zk.processTxn(packet.hdr, packet.rec);
                            break;
                        }
                        packetsNotCommitted.add(packet);
                        packetsCommitted.add(qp.getZxid());
                        break;
                    }
                    case 12: {
                        boolean majorChange;
                        LOG.info("Learner received UPTODATE message");
                        if (newLeaderQV != null && (majorChange = this.self.processReconfig(newLeaderQV, null, null, true))) {
                            throw new Exception("changes proposed in reconfig");
                        }
                        if (isPreZAB1_0) {
                            this.zk.takeSnapshot(syncSnapshot);
                            this.self.setCurrentEpoch(newEpoch);
                        }
                        this.self.setZooKeeperServer(this.zk);
                        this.self.adminServer.setZooKeeperServer(this.zk);
                        break block11;
                    }
                    case 10: {
                        QuorumVerifier qv;
                        LOG.info("Learner received NEWLEADER message");
                        if (qp.getData() != null && qp.getData().length > 1) {
                            try {
                                qv = this.self.configFromString(new String(qp.getData(), StandardCharsets.UTF_8));
                                this.self.setLastSeenQuorumVerifier(qv, true);
                                newLeaderQV = qv;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (snapshotNeeded) {
                            this.zk.takeSnapshot(syncSnapshot);
                        }
                        this.self.setCurrentEpoch(newEpoch);
                        writeToTxnLog = true;
                        isPreZAB1_0 = false;
                        this.sock.setSoTimeout(this.self.tickTime * this.self.syncLimit);
                        this.self.setSyncMode(QuorumPeer.SyncMode.NONE);
                        this.zk.startupWithoutServing();
                        if (this.zk instanceof FollowerZooKeeperServer) {
                            FollowerZooKeeperServer fzk = (FollowerZooKeeperServer)this.zk;
                            for (PacketInFlight p : packetsNotCommitted) {
                                fzk.logRequest(p.hdr, p.rec, p.digest);
                            }
                            packetsNotCommitted.clear();
                        }
                        this.writePacket(new QuorumPacket(3, newLeaderZxid, null, null), true);
                    }
                }
            }
        }
        ack.setZxid(ZxidUtils.makeZxid(newEpoch, 0L));
        this.writePacket(ack, true);
        this.zk.startServing();
        this.self.updateElectionVote(newEpoch);
        if (this.zk instanceof FollowerZooKeeperServer) {
            FollowerZooKeeperServer fzk = (FollowerZooKeeperServer)this.zk;
            for (PacketInFlight p : packetsNotCommitted) {
                fzk.logRequest(p.hdr, p.rec, p.digest);
            }
            for (Long zxid : packetsCommitted) {
                fzk.commit(zxid);
            }
            return;
        } else {
            if (!(this.zk instanceof ObserverZooKeeperServer)) {
                throw new UnsupportedOperationException("Unknown server type");
            }
            ObserverZooKeeperServer ozk = (ObserverZooKeeperServer)this.zk;
            for (PacketInFlight p : packetsNotCommitted) {
                Long zxid = (Long)packetsCommitted.peekFirst();
                if (p.hdr.getZxid() != zxid.longValue()) {
                    LOG.warn("Committing 0x{}, but next proposal is 0x{}", (Object)Long.toHexString(zxid), (Object)Long.toHexString(p.hdr.getZxid()));
                    continue;
                }
                packetsCommitted.remove();
                Request request = new Request(null, p.hdr.getClientId(), p.hdr.getCxid(), p.hdr.getType(), null, null);
                request.setTxn(p.rec);
                request.setHdr(p.hdr);
                request.setTxnDigest(p.digest);
                ozk.commitRequest(request);
            }
        }
    }

    protected void revalidate(QuorumPacket qp) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(qp.getData());
        DataInputStream dis = new DataInputStream(bis);
        long sessionId = dis.readLong();
        boolean valid = dis.readBoolean();
        ServerCnxn cnxn = this.pendingRevalidations.remove(sessionId);
        if (cnxn == null) {
            LOG.warn("Missing session 0x{} for validation", (Object)Long.toHexString(sessionId));
        } else {
            this.zk.finishSessionInit(cnxn, valid);
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(sessionId) + " is valid: " + valid);
        }
    }

    protected void ping(QuorumPacket qp) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        Map<Long, Integer> touchTable = this.zk.getTouchSnapshot();
        for (Map.Entry<Long, Integer> entry : touchTable.entrySet()) {
            dos.writeLong(entry.getKey());
            dos.writeInt(entry.getValue());
        }
        QuorumPacket pingReply = new QuorumPacket(qp.getType(), qp.getZxid(), bos.toByteArray(), qp.getAuthinfo());
        this.writePacket(pingReply, true);
    }

    public void shutdown() {
        this.self.setZooKeeperServer(null);
        this.self.closeAllConnections();
        this.self.adminServer.setZooKeeperServer(null);
        if (this.sender != null) {
            this.sender.shutdown();
        }
        this.closeSocket();
        if (this.zk != null) {
            this.zk.shutdown(this.self.getSyncMode().equals((Object)QuorumPeer.SyncMode.SNAP));
        }
    }

    boolean isRunning() {
        return this.self.isRunning() && this.zk.isRunning();
    }

    void closeSocket() {
        if (this.sock != null && this.sockBeingClosed.compareAndSet(false, true)) {
            if (closeSocketAsync) {
                Thread closingThread = new Thread(() -> this.closeSockSync(), "CloseSocketThread(sid:" + this.zk.getServerId());
                closingThread.setDaemon(true);
                closingThread.start();
            } else {
                this.closeSockSync();
            }
        }
    }

    void closeSockSync() {
        try {
            long startTime = Time.currentElapsedTime();
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
            ServerMetrics.getMetrics().SOCKET_CLOSING_TIME.add(Time.currentElapsedTime() - startTime);
        }
        catch (IOException e) {
            LOG.warn("Ignoring error closing connection to leader", (Throwable)e);
        }
    }

    static {
        LOG.info("leaderConnectDelayDuringRetryMs: {}", (Object)leaderConnectDelayDuringRetryMs);
        LOG.info("TCP NoDelay set to: {}", (Object)nodelay);
        LOG.info("{} = {}", (Object)LEARNER_ASYNC_SENDING, (Object)asyncSending);
        LOG.info("{} = {}", (Object)LEARNER_CLOSE_SOCKET_ASYNC, (Object)closeSocketAsync);
    }

    class LeaderConnector
    implements Runnable {
        private AtomicReference<Socket> socket;
        private InetSocketAddress address;
        private CountDownLatch latch;

        LeaderConnector(InetSocketAddress address, AtomicReference<Socket> socket, CountDownLatch latch) {
            this.address = address;
            this.socket = socket;
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setName("LeaderConnector-" + this.address);
                Socket sock = this.connectToLeader();
                if (sock != null && sock.isConnected()) {
                    if (this.socket.compareAndSet(null, sock)) {
                        LOG.info("Successfully connected to leader, using address: {}", (Object)this.address);
                    } else {
                        LOG.info("Connection to the leader is already established, close the redundant connection");
                        sock.close();
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Failed connect to {}", (Object)this.address, (Object)e);
            }
            finally {
                this.latch.countDown();
            }
        }

        private Socket connectToLeader() throws IOException, X509Exception, InterruptedException {
            Socket sock = Learner.this.createSocket();
            int connectTimeout = Learner.this.self.tickTime * Learner.this.self.initLimit;
            if (Learner.this.self.connectToLearnerMasterLimit > 0) {
                connectTimeout = Learner.this.self.tickTime * Learner.this.self.connectToLearnerMasterLimit;
            }
            long startNanoTime = Learner.this.nanoTime();
            for (int tries = 0; tries < 5 && this.socket.get() == null; ++tries) {
                int remainingTimeout;
                try {
                    remainingTimeout = connectTimeout - (int)((Learner.this.nanoTime() - startNanoTime) / 1000000L);
                    if (remainingTimeout <= 0) {
                        LOG.error("connectToLeader exceeded on retries.");
                        throw new IOException("connectToLeader exceeded on retries.");
                    }
                    Learner.this.sockConnect(sock, this.address, Math.min(connectTimeout, remainingTimeout));
                    if (Learner.this.self.isSslQuorum()) {
                        ((SSLSocket)sock).startHandshake();
                    }
                    sock.setTcpNoDelay(nodelay);
                    break;
                }
                catch (IOException e) {
                    remainingTimeout = connectTimeout - (int)((Learner.this.nanoTime() - startNanoTime) / 1000000L);
                    if (remainingTimeout <= leaderConnectDelayDuringRetryMs) {
                        LOG.error("Unexpected exception, connectToLeader exceeded. tries={}, remaining init limit={}, connecting to {}", new Object[]{tries, remainingTimeout, this.address, e});
                        throw e;
                    }
                    if (tries >= 4) {
                        LOG.error("Unexpected exception, retries exceeded. tries={}, remaining init limit={}, connecting to {}", new Object[]{tries, remainingTimeout, this.address, e});
                        throw e;
                    }
                    LOG.warn("Unexpected exception, tries={}, remaining init limit={}, connecting to {}", new Object[]{tries, remainingTimeout, this.address, e});
                    sock = Learner.this.createSocket();
                    Thread.sleep(leaderConnectDelayDuringRetryMs);
                    continue;
                }
            }
            return sock;
        }
    }

    static class PacketInFlight {
        TxnHeader hdr;
        Record rec;
        TxnDigest digest;

        PacketInFlight() {
        }
    }
}

