/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.filter.comparison;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.NumberComparator;
import dev.langchain4j.store.embedding.filter.comparison.TypeChecker;

public class IsLessThanOrEqualTo
implements Filter {
    private final String key;
    private final Comparable<?> comparisonValue;

    public IsLessThanOrEqualTo(String key, Comparable<?> comparisonValue) {
        this.key = ValidationUtils.ensureNotBlank(key, "key");
        this.comparisonValue = ValidationUtils.ensureNotNull(comparisonValue, "comparisonValue with key '" + key + "'");
    }

    public String key() {
        return this.key;
    }

    public Comparable<?> comparisonValue() {
        return this.comparisonValue;
    }

    @Override
    public boolean test(Object object) {
        if (!(object instanceof Metadata)) {
            return false;
        }
        Metadata metadata = (Metadata)object;
        if (!metadata.containsKey(this.key)) {
            return false;
        }
        Object actualValue = metadata.toMap().get(this.key);
        TypeChecker.ensureTypesAreCompatible(actualValue, this.comparisonValue, this.key);
        if (actualValue instanceof Number) {
            return NumberComparator.compareAsBigDecimals(actualValue, this.comparisonValue) <= 0;
        }
        return ((Comparable)actualValue).compareTo(this.comparisonValue) <= 0;
    }

    public String toString() {
        return "IsLessThanOrEqualTo(key=" + this.key + ", comparisonValue=" + this.comparisonValue + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IsLessThanOrEqualTo)) {
            return false;
        }
        IsLessThanOrEqualTo other = (IsLessThanOrEqualTo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Comparable<?> this$comparisonValue = this.comparisonValue;
        Comparable<?> other$comparisonValue = other.comparisonValue;
        return !(this$comparisonValue == null ? other$comparisonValue != null : !this$comparisonValue.equals(other$comparisonValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IsLessThanOrEqualTo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Comparable<?> $comparisonValue = this.comparisonValue;
        result = result * 59 + ($comparisonValue == null ? 43 : $comparisonValue.hashCode());
        return result;
    }
}

