/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.AbstractCell;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.MemoryUtil;
import org.apache.cassandra.utils.memory.NativeAllocator;

public class NativeCell
extends AbstractCell<ByteBuffer> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new NativeCell());
    private static final long HAS_CELLPATH = 0L;
    private static final long TIMESTAMP = 1L;
    private static final long TTL = 9L;
    private static final long DELETION = 13L;
    private static final long LENGTH = 17L;
    private static final long VALUE = 21L;
    private final long peer;

    private NativeCell() {
        super(null);
        this.peer = 0L;
    }

    public NativeCell(NativeAllocator allocator, OpOrder.Group writeOp, Cell<?> cell) {
        this(allocator, writeOp, cell.column(), cell.timestamp(), cell.ttl(), cell.localDeletionTime(), cell.buffer(), cell.path());
    }

    public NativeCell(NativeAllocator allocator, OpOrder.Group writeOp, ColumnMetadata column, long timestamp, int ttl, int localDeletionTime, ByteBuffer value, CellPath path) {
        super(column);
        long size = NativeCell.offHeapSizeWithoutPath(value.remaining());
        assert (value.order() == ByteOrder.BIG_ENDIAN);
        assert (column.isComplex() == (path != null));
        if (path != null) {
            assert (path.size() == 1) : String.format("Expected path size to be 1 but was not; %s", path);
            size += (long)(4 + path.get(0).remaining());
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        this.peer = allocator.allocate((int)size, writeOp);
        MemoryUtil.setByte(this.peer + 0L, (byte)(path != null ? 1 : 0));
        MemoryUtil.setLong(this.peer + 1L, timestamp);
        MemoryUtil.setInt(this.peer + 9L, ttl);
        MemoryUtil.setInt(this.peer + 13L, localDeletionTime);
        MemoryUtil.setInt(this.peer + 17L, value.remaining());
        MemoryUtil.setBytes(this.peer + 21L, value);
        if (path != null) {
            ByteBuffer pathbuffer = path.get(0);
            assert (pathbuffer.order() == ByteOrder.BIG_ENDIAN);
            long offset = this.peer + 21L + (long)value.remaining();
            MemoryUtil.setInt(offset, pathbuffer.remaining());
            MemoryUtil.setBytes(offset + 4L, pathbuffer);
        }
    }

    private static long offHeapSizeWithoutPath(int length) {
        return 21L + (long)length;
    }

    @Override
    public long timestamp() {
        return MemoryUtil.getLong(this.peer + 1L);
    }

    @Override
    public int ttl() {
        return MemoryUtil.getInt(this.peer + 9L);
    }

    @Override
    public int localDeletionTime() {
        return MemoryUtil.getInt(this.peer + 13L);
    }

    @Override
    public ByteBuffer value() {
        int length = MemoryUtil.getInt(this.peer + 17L);
        return MemoryUtil.getByteBuffer(this.peer + 21L, length, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public ValueAccessor<ByteBuffer> accessor() {
        return ByteBufferAccessor.instance;
    }

    @Override
    public CellPath path() {
        if (!this.hasPath()) {
            return null;
        }
        long offset = this.peer + 21L + (long)MemoryUtil.getInt(this.peer + 17L);
        int size = MemoryUtil.getInt(offset);
        return CellPath.create(MemoryUtil.getByteBuffer(offset + 4L, size, ByteOrder.BIG_ENDIAN));
    }

    @Override
    public Cell<?> withUpdatedValue(ByteBuffer newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cell<?> withUpdatedTimestampAndLocalDeletionTime(long newTimestamp, int newLocalDeletionTime) {
        return new BufferCell(this.column, newTimestamp, this.ttl(), newLocalDeletionTime, this.value(), this.path());
    }

    @Override
    public Cell<?> withUpdatedColumn(ColumnMetadata column) {
        return new BufferCell(column, this.timestamp(), this.ttl(), this.localDeletionTime(), this.value(), this.path());
    }

    @Override
    public Cell withSkippedValue() {
        return new BufferCell(this.column, this.timestamp(), this.ttl(), this.localDeletionTime(), ByteBufferUtil.EMPTY_BYTE_BUFFER, this.path());
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE;
    }

    public long offHeapSize() {
        long size = NativeCell.offHeapSizeWithoutPath(MemoryUtil.getInt(this.peer + 17L));
        if (this.hasPath()) {
            size += (long)(4 + MemoryUtil.getInt(this.peer + size));
        }
        return size;
    }

    private boolean hasPath() {
        return MemoryUtil.getByte(this.peer + 0L) != 0;
    }
}

