/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.metadata.Node;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class ChannelEvent {
    public final Type type;
    public final Node node;

    public static ChannelEvent channelOpened(Node node) {
        return new ChannelEvent(Type.OPENED, node);
    }

    public static ChannelEvent channelClosed(Node node) {
        return new ChannelEvent(Type.CLOSED, node);
    }

    public static ChannelEvent reconnectionStarted(Node node) {
        return new ChannelEvent(Type.RECONNECTION_STARTED, node);
    }

    public static ChannelEvent reconnectionStopped(Node node) {
        return new ChannelEvent(Type.RECONNECTION_STOPPED, node);
    }

    public static ChannelEvent controlConnectionFailed(Node node) {
        return new ChannelEvent(Type.CONTROL_CONNECTION_FAILED, node);
    }

    public ChannelEvent(Type type, Node node) {
        this.type = type;
        this.node = node;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ChannelEvent) {
            ChannelEvent that = (ChannelEvent)other;
            return this.type == that.type && Objects.equals(this.node, that.node);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.node});
    }

    public String toString() {
        return "ChannelEvent(" + (Object)((Object)this.type) + ", " + this.node + ")";
    }

    public static enum Type {
        OPENED,
        CLOSED,
        RECONNECTION_STARTED,
        RECONNECTION_STOPPED,
        CONTROL_CONNECTION_FAILED;

    }
}

