/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.as;

import com.nimbusds.oauth2.sdk.AbstractRequest;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import net.jcip.annotations.Immutable;

@Immutable
public class AuthorizationServerConfigurationRequest
extends AbstractRequest {
    public static final String OAUTH_SERVER_WELL_KNOWN_PATH = "/.well-known/oauth-authorization-server";

    public AuthorizationServerConfigurationRequest(Issuer issuer) {
        super(URI.create(URIUtils.removeTrailingSlash(URI.create(issuer.getValue())) + OAUTH_SERVER_WELL_KNOWN_PATH));
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        URL url;
        try {
            url = this.getEndpointURI().toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        return new HTTPRequest(HTTPRequest.Method.GET, url);
    }
}

