/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.ui.hopgui.context;

import java.util.List;
import org.apache.hop.core.gui.plugin.action.GuiAction;

/**
 * This class handles actions for a certain context. For example, the main HopGui dialog registers a
 * bunch of context handlers for MetaStore objects, asks the various perspectives, ...
 */
public interface IGuiContextHandler {
  /**
   * @return Get a list of all the supported actions by this context handler
   */
  List<GuiAction> getSupportedActions();

  /**
   * @return The name of the context handler
   */
  String getContextId();
}
