/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.managers.systemview.walker;

import java.util.Date;
import java.util.UUID;
import org.apache.ignite.spi.systemview.view.SqlQueryView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

/**
 * Generated by {@code org.apache.ignite.codegen.SystemViewRowAttributeWalkerGenerator}.
 * {@link SqlQueryView} attributes walker.
 * 
 * @see SqlQueryView
 */
public class SqlQueryViewWalker implements SystemViewRowAttributeWalker<SqlQueryView> {
    /** {@inheritDoc} */
    @Override public void visitAll(AttributeVisitor v) {
        v.accept(0, "queryId", String.class);
        v.accept(1, "sql", String.class);
        v.accept(2, "originNodeId", UUID.class);
        v.accept(3, "startTime", Date.class);
        v.accept(4, "duration", long.class);
        v.accept(5, "initiatorId", String.class);
        v.accept(6, "local", boolean.class);
        v.accept(7, "schemaName", String.class);
        v.accept(8, "subjectId", UUID.class);
    }

    /** {@inheritDoc} */
    @Override public void visitAll(SqlQueryView row, AttributeWithValueVisitor v) {
        v.accept(0, "queryId", String.class, row.queryId());
        v.accept(1, "sql", String.class, row.sql());
        v.accept(2, "originNodeId", UUID.class, row.originNodeId());
        v.accept(3, "startTime", Date.class, row.startTime());
        v.acceptLong(4, "duration", row.duration());
        v.accept(5, "initiatorId", String.class, row.initiatorId());
        v.acceptBoolean(6, "local", row.local());
        v.accept(7, "schemaName", String.class, row.schemaName());
        v.accept(8, "subjectId", UUID.class, row.subjectId());
    }

    /** {@inheritDoc} */
    @Override public int count() {
        return 9;
    }
}
