/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.tracing.messages;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.tracing.NoopSpan;
import org.apache.ignite.internal.processors.tracing.SpanManager;
import org.apache.ignite.internal.processors.tracing.messages.TraceableMessage;
import org.apache.ignite.internal.processors.tracing.messages.TraceableMessagesTable;

public class TraceableMessagesHandler {
    private final SpanManager spanMgr;
    private final IgniteLogger log;

    public TraceableMessagesHandler(SpanManager spanMgr, IgniteLogger log) {
        this.spanMgr = spanMgr;
        this.log = log;
    }

    public void afterReceive(TraceableMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received traceable message: " + msg);
        }
        if (msg.spanContainer().span() == NoopSpan.INSTANCE && msg.spanContainer().serializedSpanBytes() != null) {
            msg.spanContainer().span(this.spanMgr.create(TraceableMessagesTable.traceName(msg.getClass()), msg.spanContainer().serializedSpanBytes()).addLog(() -> "Received"));
        }
    }

    public void beforeSend(TraceableMessage msg) {
        if (msg.spanContainer().span() != NoopSpan.INSTANCE && msg.spanContainer().serializedSpanBytes() == null) {
            msg.spanContainer().serializedSpanBytes(this.spanMgr.serialize(msg.spanContainer().span()));
        }
    }

    public <T extends TraceableMessage> T branch(T msg, TraceableMessage parent) {
        assert (parent.spanContainer().span() != null) : parent;
        msg.spanContainer().serializedSpanBytes(this.spanMgr.serialize(parent.spanContainer().span()));
        msg.spanContainer().span(this.spanMgr.create(TraceableMessagesTable.traceName(msg.getClass()), parent.spanContainer().span()).addLog(() -> "Created"));
        return msg;
    }

    public void finishProcessing(TraceableMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processed traceable message: " + msg);
        }
        if (!msg.spanContainer().span().isEnded()) {
            msg.spanContainer().span().addLog(() -> "Processed").end();
        }
    }
}

