/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.cluster.unit;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.ignite.rest.client.invoker.ApiCallback;
import org.apache.ignite.rest.client.invoker.ApiClient;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.ApiResponse;
import org.apache.ignite.rest.client.invoker.Pair;
import org.apache.ignite.rest.client.invoker.ProgressRequestBody;
import org.apache.ignite.rest.client.model.DeployMode;
import org.jetbrains.annotations.Nullable;

public class DeployUnitClient {
    private final ApiClient apiClient;

    public DeployUnitClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Boolean deployUnit(String unitId, List<File> unitContent, String unitVersion, DeployMode deployMode, List<String> initialNodes) throws ApiException {
        Call call = this.deployUnitCall(unitId, unitContent, unitVersion, deployMode, initialNodes, null);
        ApiResponse response = this.apiClient.execute(call, (Type)((Object)Boolean.class));
        return (Boolean)response.getData();
    }

    public Call deployUnitAsync(String unitId, List<File> unitContent, String unitVersion, @Nullable DeployMode deployMode, @Nullable List<String> initialNodes, ApiCallback<Boolean> callback) {
        Call call = this.deployUnitCall(unitId, unitContent, unitVersion, deployMode, initialNodes, callback);
        this.apiClient.executeAsync(call, (Type)((Object)Boolean.class), callback);
        return call;
    }

    private Call deployUnitCall(String unitId, List<File> unitContent, String unitVersion, @Nullable DeployMode deployMode, @Nullable List<String> initialNodes, ApiCallback<Boolean> callback) {
        StringBuilder url = new StringBuilder(this.apiClient.getBasePath());
        url.append("/management/v1/deployment/units").append('/').append(this.apiClient.escapeString(unitId)).append('/').append(this.apiClient.escapeString(unitVersion));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        if (deployMode != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("multi", "deployMode", List.of(deployMode)));
        }
        if (initialNodes != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("multi", "initialNodes", initialNodes));
        }
        if (!queryParams.isEmpty()) {
            url.append(queryParams.stream().map(pair -> pair.getName() + "=" + pair.getValue()).collect(Collectors.joining("&", "?", "")));
        }
        MultipartBody.Builder mpBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (File file : unitContent) {
            RequestBody requestBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)"application/octet-stream"));
            mpBuilder.addFormDataPart("unitContent", file.getName(), requestBody);
        }
        MultipartBody body = mpBuilder.build();
        Request.Builder reqBuilder = new Request.Builder().url(url.toString()).header("Accept", "application/json").header("Content-Type", "multipart/form-data");
        if (callback != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody((RequestBody)body, callback);
            reqBuilder.tag(callback).post((RequestBody)progressRequestBody);
        } else {
            reqBuilder.post((RequestBody)body);
        }
        return this.apiClient.getHttpClient().newCall(reqBuilder.build());
    }
}

