/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CompletableFutures;

public class ReadOperationForCompactionTracker {
    private final Map<ReadOperationKey, CompletableFuture<Void>> readOperationFutureByKey = new ConcurrentHashMap<ReadOperationKey, CompletableFuture<Void>>();
    private final AtomicLong longOperationIdGenerator = new AtomicLong();

    public long generateReadOperationId() {
        return this.longOperationIdGenerator.getAndIncrement();
    }

    public void track(Object readOperationId, long compactionRevision) {
        ReadOperationKey key = new ReadOperationKey(readOperationId, compactionRevision);
        CompletableFuture previous = this.readOperationFutureByKey.putIfAbsent(key, new CompletableFuture());
        assert (previous == null) : key;
    }

    public void untrack(Object readOperationId, long compactionRevision) {
        ReadOperationKey key = new ReadOperationKey(readOperationId, compactionRevision);
        CompletableFuture<Void> removed = this.readOperationFutureByKey.remove(key);
        assert (removed != null) : key;
        removed.complete(null);
    }

    public CompletableFuture<Void> collect(long compactionRevisionExcluded) {
        return this.readOperationFutureByKey.entrySet().stream().filter(entry -> ((ReadOperationKey)entry.getKey()).compactionRevision < compactionRevisionExcluded).map(Map.Entry::getValue).collect(Collectors.collectingAndThen(Collectors.toList(), CompletableFutures::allOf));
    }

    private static class ReadOperationKey {
        @IgniteToStringInclude
        private final Object readOperationId;
        private final long compactionRevision;

        private ReadOperationKey(Object readOperationId, long compactionRevision) {
            this.readOperationId = readOperationId;
            this.compactionRevision = compactionRevision;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReadOperationKey that = (ReadOperationKey)o;
            return this.compactionRevision == that.compactionRevision && this.readOperationId.equals(that.readOperationId);
        }

        public int hashCode() {
            int result = this.readOperationId.hashCode();
            result = 31 * result + (int)(this.compactionRevision ^ this.compactionRevision >>> 32);
            return result;
        }

        public String toString() {
            return S.toString((Object)this);
        }
    }
}

