/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class RuleEventLogger
implements RelOptListener {
    private static final Logger LOG = CalciteTrace.getPlannerTracer();
    private static final Marker FULL = MarkerFactory.getMarker((String)"FULL_PLAN");

    @Override
    public void relEquivalenceFound(RelOptListener.RelEquivalenceEvent event) {
    }

    @Override
    public void ruleAttempted(RelOptListener.RuleAttemptedEvent event) {
        if (event.isBefore() && LOG.isDebugEnabled()) {
            RelOptRuleCall call = event.getRuleCall();
            String ruleArgs = Arrays.stream(call.rels).map(rel -> "rel#" + rel.getId() + ":" + rel.getRelTypeName()).collect(Collectors.joining(","));
            LOG.debug("call#{}: Apply rule [{}] to [{}]", new Object[]{call.id, call.getRule(), ruleArgs});
        }
    }

    @Override
    public void ruleProductionSucceeded(RelOptListener.RuleProductionEvent event) {
        if (event.isBefore() && LOG.isDebugEnabled()) {
            RelOptRuleCall call = event.getRuleCall();
            Arrays.stream(call.rels).forEach(rel -> LOG.debug(FULL, "call#{}: Full plan for rule input [rel#{}:{}]: {}", new Object[]{call.id, rel.getId(), rel.getRelTypeName(), System.lineSeparator() + RelOptUtil.toString(rel)}));
            RelNode newRel = event.getRel();
            String description = newRel == null ? "null" : "rel#" + newRel.getId() + ":" + newRel.getRelTypeName();
            LOG.debug("call#{}: Rule [{}] produced [{}]", new Object[]{call.id, call.getRule(), description});
            if (newRel != null) {
                LOG.debug(FULL, "call#{}: Full plan for [{}]:{}", new Object[]{call.id, description, System.lineSeparator() + RelOptUtil.toString(newRel)});
            }
        }
    }

    @Override
    public void relDiscarded(RelOptListener.RelDiscardedEvent event) {
    }

    @Override
    public void relChosen(RelOptListener.RelChosenEvent event) {
    }
}

