/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequestParser;
import org.apache.iceberg.util.JsonUtil;

public class CommitTransactionRequestParser {
    private static final String TABLE_CHANGES = "table-changes";

    private CommitTransactionRequestParser() {
    }

    public static String toJson(CommitTransactionRequest request) {
        return CommitTransactionRequestParser.toJson(request, false);
    }

    public static String toJson(CommitTransactionRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> CommitTransactionRequestParser.toJson(request, gen), pretty);
    }

    public static void toJson(CommitTransactionRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != request ? 1 : 0) != 0, (Object)"Invalid commit transaction request: null");
        gen.writeStartObject();
        gen.writeFieldName(TABLE_CHANGES);
        gen.writeStartArray();
        for (UpdateTableRequest tableChange : request.tableChanges()) {
            UpdateTableRequestParser.toJson(tableChange, gen);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    public static CommitTransactionRequest fromJson(String json) {
        return JsonUtil.parse(json, CommitTransactionRequestParser::fromJson);
    }

    public static CommitTransactionRequest fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse commit transaction request from null object");
        ArrayList tableChanges = Lists.newArrayList();
        JsonNode changes = JsonUtil.get(TABLE_CHANGES, json);
        Preconditions.checkArgument((boolean)changes.isArray(), (String)"Cannot parse commit transaction request from non-array: %s", (Object)changes);
        for (JsonNode node : changes) {
            tableChanges.add(UpdateTableRequestParser.fromJson(node));
        }
        return new CommitTransactionRequest(tableChanges);
    }
}

