/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job;

import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import com.xiaomi.youpin.docean.plugin.nacos.NacosNaming;
import javax.annotation.Resource;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.stream.common.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class ServiceRegistryService {
    private static final Logger log = LoggerFactory.getLogger(ServiceRegistryService.class);
    @Value(value="$app_name")
    private String serviceName;
    @Value(value="$nacos_config_server_addr")
    private String nacosAddr;
    @Resource
    private NacosNaming nacosNaming;

    public void init() {
        try {
            this.nacosNaming.registerInstance(this.serviceName, StreamUtils.buildInstance(this.serviceName));
        }
        catch (Exception e) {
            log.error("register stream service error,nacos address:{}", (Object)this.nacosAddr, (Object)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.nacosNaming.deregisterInstance(this.serviceName, StreamUtils.getIp(), this.getServicePort());
            }
            catch (Exception e) {
                log.warn("Failed to deregister service instance during shutdown", (Throwable)e);
            }
        }));
    }

    private int getServicePort() {
        return Integer.parseInt(Config.ins().get("service_port", "7789"));
    }
}

