/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension.impl;

import com.alibaba.fastjson.JSON;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import com.xiaomi.mone.es.EsProcessor;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.parse.LogParser;
import org.apache.ozhera.log.stream.job.compensate.MqMessageDTO;
import org.apache.ozhera.log.stream.job.extension.CompensateMsgConsume;
import org.apache.ozhera.log.stream.plugin.es.EsPlugin;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketCompensateMsgConsume
implements CompensateMsgConsume {
    private static final Logger log = LoggerFactory.getLogger(RocketCompensateMsgConsume.class);

    @Override
    public void consume(String ak, String sk, String serviceUrl, String topic) {
        log.info("\u3010RocketMqMessageConsume\u3011consumer mq service init");
        String mqGroup = Config.ins().get("rocketmq_group", "hear_log_stream");
        DefaultMQPushConsumer consumer = this.initDefaultMQPushConsumer(ak, sk, mqGroup, serviceUrl);
        try {
            consumer.subscribe(topic, "");
        }
        catch (MQClientException e) {
            log.error("\u3010RocketMqMessageConsume\u3011Subscription to Rocket Mq consumption exception", (Throwable)e);
        }
        consumer.registerMessageListener((list, consumeOrderlyContext) -> {
            list.stream().forEach(ele -> {
                byte[] body = ele.getBody();
                String str = new String(body);
                log.info("RocketMqMessageConsume.consume:{}", (Object)str);
                MqMessageDTO mqMessageDTO = (MqMessageDTO)Constant.GSON.fromJson(str, MqMessageDTO.class);
                this.sendMessageReply(mqMessageDTO);
            });
            return ConsumeOrderlyStatus.SUCCESS;
        });
        try {
            consumer.start();
        }
        catch (MQClientException e) {
            log.error("\u3010RocketMqMessageConsume\u3011Subscription to Rocket Mq consumption exception", (Throwable)e);
        }
    }

    public DefaultMQPushConsumer initDefaultMQPushConsumer(String ak, String sk, String consumerGroup, String address) {
        DefaultMQPushConsumer defaultMQPushConsumer;
        if (!ak.equals("") && !sk.equals("")) {
            SessionCredentials credentials = new SessionCredentials(ak, sk);
            AclClientRPCHook rpcHook = new AclClientRPCHook(credentials);
            defaultMQPushConsumer = new DefaultMQPushConsumer(consumerGroup, (RPCHook)rpcHook, (AllocateMessageQueueStrategy)new AllocateMessageQueueAveragely());
        } else {
            defaultMQPushConsumer = new DefaultMQPushConsumer(consumerGroup);
        }
        defaultMQPushConsumer.setNamesrvAddr(address);
        defaultMQPushConsumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET);
        return defaultMQPushConsumer;
    }

    @Override
    public void consume() {
        String ak = Config.ins().get("rocketmq_ak", "");
        String sk = Config.ins().get("rocketmq_sk", "");
        String serviceUrl = Config.ins().get("rocketmq_service_url", "");
        String topic = Config.ins().get("rocketmq_producer_topic", "");
        this.consume(ak, sk, serviceUrl, topic);
        log.info("compensate consume  message succeed");
    }

    private void sendMessageReply(MqMessageDTO mqMessageDTO) {
        log.info("Compensate Message content: " + Constant.GSON.toJson((Object)mqMessageDTO));
        List<MqMessageDTO.CompensateMqDTO> compensateMqDTOS = mqMessageDTO.getCompensateMqDTOS();
        if (CollectionUtils.isNotEmpty(compensateMqDTOS)) {
            compensateMqDTOS.forEach(compensateMqDTO -> {
                String esIndex = compensateMqDTO.getEsIndex();
                String message = compensateMqDTO.getMsg();
                LinkedTreeMap hashMap = (LinkedTreeMap)Constant.GSON.fromJson(message, new TypeToken<LinkedTreeMap<String, Object>>(this){}.getType());
                try {
                    Long timeStamp = JSON.parseObject((String)message).getLong("timestamp");
                    if (null != timeStamp && String.valueOf(timeStamp).length() != LogParser.TIME_STAMP_MILLI_LENGTH.intValue()) {
                        hashMap.put((Object)"timestamp", (Object)Instant.now().toEpochMilli());
                    }
                }
                catch (Exception e) {
                    hashMap.put((Object)"timestamp", (Object)Instant.now().toEpochMilli());
                }
                log.info("mq index timestamp data:{},current timestamp:{}", hashMap.get((Object)"timestamp"), (Object)Instant.now().toEpochMilli());
                EsProcessor esProcessor = EsPlugin.getEsProcessor(mqMessageDTO.getEsInfo(), mqMessageDTO1 -> log.error("compensate msg store failed, data size:{}", (Object)mqMessageDTO1.getCompensateMqDTOS().size()));
                esProcessor.bulkInsert(esIndex, (Map)hashMap);
            });
        }
    }
}

