/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension.rocketmq;

import org.apache.ozhera.log.api.enums.MQSourceEnum;
import org.apache.ozhera.log.stream.exception.StreamException;
import org.apache.ozhera.log.stream.job.LogDataTransfer;
import org.apache.ozhera.log.stream.job.extension.SinkJob;
import org.apache.ozhera.log.stream.job.extension.rocketmq.RocketmqConfig;
import org.apache.ozhera.log.utils.DateUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMqSinkJob
implements SinkJob {
    private static final Logger log = LoggerFactory.getLogger(RocketMqSinkJob.class);
    private final RocketmqConfig rocketmqConfig;
    private final DefaultMQPushConsumer consumer;
    private final LogDataTransfer handleMessage;

    public RocketMqSinkJob(RocketmqConfig rocketmqConfig, DefaultMQPushConsumer consumer, LogDataTransfer handleMessage) {
        this.rocketmqConfig = rocketmqConfig;
        this.consumer = consumer;
        this.handleMessage = handleMessage;
    }

    @Override
    public boolean start() throws Exception {
        String topicName = this.rocketmqConfig.getTopicName();
        String tag = this.rocketmqConfig.getTag();
        try {
            this.consumer.subscribe(topicName, tag);
            log.info("[RmqSinkJob.start] job subscribed topic [topic:{},tag:{}]", (Object)topicName, (Object)tag);
            this.consumer.registerMessageListener((list, consumeOrderlyContext) -> {
                String time = DateUtils.getTime();
                for (MessageExt messageExt : list) {
                    Object m = null;
                    String msg = new String(messageExt.getBody());
                    this.handleMessage.handleMessage(MQSourceEnum.ROCKETMQ.getName(), msg, time);
                }
                return ConsumeOrderlyStatus.SUCCESS;
            });
            this.consumer.start();
            return true;
        }
        catch (Throwable e) {
            log.error(String.format("[RmqSinkJob.start] logStream rockerMq start error,topic:%s,tag:%s", topicName, tag), (Throwable)new RuntimeException(e));
            throw new StreamException("[RmqSinkJob.start] job subscribed topic error,topic: " + topicName + " tag: " + tag + " err: ", e);
        }
    }

    @Override
    public void shutdown() throws Exception {
        this.consumer.shutdown();
        log.info("[RmqSinkJob.rocketmq shutdown] job consumer shutdown, topic:{},tag:{}", (Object)this.rocketmqConfig.getTopicName(), (Object)this.rocketmqConfig.getTag());
    }
}

