/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.sink;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.stream.sink.SinkProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class SinkChain {
    private static final Logger log = LoggerFactory.getLogger(SinkChain.class);
    private volatile boolean isLoad;
    private static final List<SinkProcessor> sinkProcessorList = new CopyOnWriteArrayList<SinkProcessor>();
    private ReentrantLock reentrantLock = new ReentrantLock();

    public boolean execute(Map<String, Object> map) {
        this.loadSinkProcessor();
        ArrayList res = Lists.newArrayList();
        for (SinkProcessor sinkProcessor : sinkProcessorList) {
            if (null == sinkProcessor) continue;
            res.add(sinkProcessor.execute(map));
        }
        return res.stream().anyMatch(re -> re);
    }

    private void loadSinkProcessor() {
        if (!this.isLoad) {
            this.reentrantLock.lock();
            try {
                if (!this.isLoad) {
                    Set beans = Ioc.ins().getBeans(SinkProcessor.class);
                    if (CollectionUtils.isNotEmpty((Collection)beans)) {
                        sinkProcessorList.addAll(beans);
                    }
                    this.isLoad = true;
                }
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
    }
}

