/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.api.enums;

import java.util.Arrays;
import java.util.Objects;

public enum MachineTypeEnum {
    CONTAINER_MACHINE(0, "\u5bb9\u5668"),
    PHYSICAL_MACHINE(1, "\u7269\u7406\u673a");

    private final Integer type;
    private final String name;

    private MachineTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public static MachineTypeEnum queryEnumByType(int type) {
        return Arrays.stream(MachineTypeEnum.values()).filter(machineTypeEnum -> Objects.equals(machineTypeEnum.type, type)).findFirst().orElse(null);
    }

    public static String queryNameByType(int type) {
        MachineTypeEnum machineTypeEnum = MachineTypeEnum.queryEnumByType(type);
        if (null != machineTypeEnum) {
            return machineTypeEnum.getName();
        }
        return "";
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }
}

