/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.api.filter;

import org.apache.ozhera.log.api.model.meta.FilterType;

public enum RateLimitStrategy {
    REGINAL_FAST("RATELIMITCODE0", FilterType.REGIONAL, 100, "", 1500),
    REGINAL_MEDIUM("RATELIMITCODE1", FilterType.REGIONAL, 100, "", 100),
    REGINAL_SLOW("RATELIMITCODE2", FilterType.REGIONAL, 100, "", 30),
    REGINAL_NONE("RATELIMITCODE3", FilterType.REGIONAL, 100, "", 10),
    GLOBAL_FAST("RATELIMITCODE4", FilterType.GLOBAL, 10, "", 50),
    GLOBAL_MEDIUM("RATELIMITCODE5", FilterType.GLOBAL, 10, "", 20),
    GLOBAL_SLOW("RATELIMITCODE6", FilterType.GLOBAL, 10, "", 10),
    GLOBAL_NONE("RATELIMITCODE7", FilterType.GLOBAL, 10, "", 5);

    private String code;
    private Integer order;
    private FilterType type;
    private String lifecycle;
    private Integer permitsPerSecond;

    private RateLimitStrategy(String code, FilterType type, Integer order, String lifecycle, Integer permitsPerSecond) {
        this.code = code;
        this.order = order;
        this.type = type;
        this.lifecycle = lifecycle;
        this.permitsPerSecond = permitsPerSecond;
    }

    public static RateLimitStrategy getRateLimiterStrategy(String code) {
        if (code == null) {
            return null;
        }
        switch (code) {
            case "RATELIMITCODE0": {
                return REGINAL_FAST;
            }
            case "RATELIMITCODE1": {
                return REGINAL_MEDIUM;
            }
            case "RATELIMITCODE2": {
                return REGINAL_SLOW;
            }
            case "RATELIMITCODE3": {
                return REGINAL_NONE;
            }
            case "RATELIMITCODE4": {
                return GLOBAL_FAST;
            }
            case "RATELIMITCODE5": {
                return GLOBAL_MEDIUM;
            }
            case "RATELIMITCODE6": {
                return GLOBAL_SLOW;
            }
            case "RATELIMITCODE7": {
                return GLOBAL_NONE;
            }
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public Integer getOrder() {
        return this.order;
    }

    public FilterType getType() {
        return this.type;
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public Integer getPermitsPerSecond() {
        return this.permitsPerSecond;
    }
}

