/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel.file;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.comparator.DefaultFileComparator;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.ozhera.log.agent.channel.memory.ChannelMemory;
import org.apache.ozhera.log.agent.common.ChannelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InodeFileComparator
extends DefaultFileComparator {
    private static final Logger log = LoggerFactory.getLogger(InodeFileComparator.class);
    public static final Comparator<File> INODE_COMPARATOR = new InodeFileComparator();
    private static final Comparator<File> fileComparator = NameFileComparator.NAME_SYSTEM_COMPARATOR;
    private static final Map<String, Long> INODE_MAP = new HashMap<String, Long>();
    private static final List<String> filePaths = Lists.newArrayList();

    public int compare(File file1, File file2) {
        int sort = fileComparator.compare(file1, file2);
        if (file1.isDirectory() || file2.isDirectory()) {
            return sort;
        }
        if (sort == 0 && filePaths.contains(file1.getAbsolutePath())) {
            Long oldInode;
            if (INODE_MAP.containsKey(file1.getAbsolutePath())) {
                oldInode = INODE_MAP.get(file1.getAbsolutePath());
            } else {
                oldInode = ChannelUtil.buildUnixFileNode(file1.getAbsolutePath()).getSt_ino();
                INODE_MAP.put(file1.getAbsolutePath(), oldInode);
            }
            ChannelMemory.UnixFileNode unixFileNode2 = ChannelUtil.buildUnixFileNode(file2.getAbsolutePath());
            if (!Objects.equals(oldInode, unixFileNode2.getSt_ino())) {
                INODE_MAP.put(file2.getAbsolutePath(), unixFileNode2.getSt_ino());
                return 1;
            }
        }
        return sort;
    }

    public static void addFile(String filePath) {
        filePaths.add(filePath);
    }

    public static void removeFile(String filePath) {
        filePaths.remove(filePath);
    }
}

