/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.db.interceptor;

import com.xiaomi.youpin.docean.plugin.datasource.DatasourceConfig;
import com.xiaomi.youpin.docean.plugin.db.interceptor.NutzDaoMeshInvoker;
import com.xiaomi.youpin.docean.plugin.db.po.DbRequest;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.nutz.dao.DaoException;
import org.nutz.dao.DaoInterceptor;
import org.nutz.dao.DaoInterceptorChain;
import org.nutz.dao.impl.jdbc.NutPojo;
import org.nutz.dao.sql.SqlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoceanInterceptor
implements DaoInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DoceanInterceptor.class);
    private NutzDaoMeshInvoker meshInvoker;
    private DatasourceConfig datasourceConfig;

    public void filter(DaoInterceptorChain chain) throws DaoException {
        String statement = chain.getDaoStatement().toString();
        String ds = this.ds(chain);
        log.info("nutz dao mesh filter sql:{}", (Object)statement);
        if (null != this.meshInvoker) {
            NutPojo np = (NutPojo)chain.getDaoStatement();
            if (np.getSqlType().equals((Object)SqlType.UPDATE) || np.getSqlType().equals((Object)SqlType.INSERT) || np.getSqlType().equals((Object)SqlType.DELETE)) {
                int n = this.meshInvoker.update(DbRequest.builder().entity(np.getEntity()).sql(statement).dsName(this.datasourceConfig.getName()).type(np.getSqlType().name()).datasource(ds).build());
                np.getContext().setUpdateCount(n);
                this.setProperty(chain, "updateCount", n);
            } else {
                List list = this.meshInvoker.query(DbRequest.builder().sql(statement).dsName(this.datasourceConfig.getName()).entity(np.getEntity()).type(np.getSqlType().name()).datasource(ds).build());
                np.getContext().setResult((Object)list);
            }
        } else {
            chain.doChain();
        }
    }

    private String ds(DaoInterceptorChain chain) {
        String url = chain.getConnection().getMetaData().getURL();
        String ds = Arrays.stream(url.split("&")).filter((? super T it) -> it.startsWith("mds=")).findFirst().orElse("mds=default").split("=")[1];
        return ds;
    }

    protected void setProperty(Object obj, String property, Object value) {
        if (null != value) {
            Field field = obj.getClass().getDeclaredField(property);
            field.setAccessible(true);
            field.set(obj, value);
        }
    }

    public void setMeshInvoker(NutzDaoMeshInvoker meshInvoker) {
        this.meshInvoker = meshInvoker;
    }

    public void setDatasourceConfig(DatasourceConfig datasourceConfig) {
        this.datasourceConfig = datasourceConfig;
    }
}

