/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.doris;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.trace.etl.domain.DriverDomain;
import org.apache.ozhera.trace.etl.domain.ErrorTraceMessage;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerAttribute;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerLogs;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerProcess;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerReferences;
import org.apache.ozhera.tspandata.TAttributeKey;
import org.apache.ozhera.tspandata.TAttributes;
import org.apache.ozhera.tspandata.TEvent;
import org.apache.ozhera.tspandata.TLink;
import org.apache.ozhera.tspandata.TResource;
import org.apache.ozhera.tspandata.TSpanContext;
import org.apache.ozhera.tspandata.TSpanData;
import org.apache.ozhera.tspandata.TValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import run.mone.doris.DorisService;

public class WriteDorisService {
    private static final Logger log = LoggerFactory.getLogger(WriteDorisService.class);
    @Autowired
    private DorisService dorisService;
    private Cache<String, String> localCache = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite(86400L, TimeUnit.SECONDS).build();
    private static final List<String> TRACE_SERVICE_COLUMN = Arrays.asList("serviceName", "operationName", "timestamp");
    private static final List<String> TRACE_ERROR_SLOW_TRACE_COLUMN = Arrays.asList("domain", "type", "host", "url", "dataSource", "serviceName", "traceId", "timestamp", "duration", "errorType", "errorCode", "serverEnv", "functionId", "functionName");
    private static final List<String> TRACE_DRIVER_COLUMN = Arrays.asList("type", "timestamp", "ip", "appName", "dataBaseName", "password", "domainPort", "userName");
    private static final List<String> TRACE_SPAN_COLUMN = Arrays.asList("traceID", "spanID", "operationName", "startTime", "startTimeMillis", "duration", "references", "tags", "logs", "process");
    private static final Gson GSON = new Gson();

    public void insertHeraTraceService(String serviceName, String operationName) {
        String key = serviceName + ":" + operationName;
        if (!this.localCache.asMap().containsKey(key)) {
            try {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("serviceName", serviceName);
                data.put("operationName", operationName);
                data.put("timestamp", System.currentTimeMillis());
                this.dorisService.send("hera_trace_service", TRACE_SERVICE_COLUMN, data);
                this.localCache.put((Object)key, (Object)"1");
            }
            catch (Exception e) {
                log.error("insert service error : ", (Throwable)e);
            }
        }
    }

    public void insertErrorTrace(ErrorTraceMessage errorTraceMessage) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("domain", errorTraceMessage.getDomain());
        data.put("type", errorTraceMessage.getType());
        data.put("host", errorTraceMessage.getHost());
        data.put("url", errorTraceMessage.getUrl());
        data.put("dataSource", errorTraceMessage.getDataSource());
        data.put("serviceName", errorTraceMessage.getServiceName());
        data.put("traceId", errorTraceMessage.getTraceId());
        data.put("timestamp", errorTraceMessage.getTimestamp());
        data.put("duration", errorTraceMessage.getDuration());
        data.put("errorType", errorTraceMessage.getErrorType());
        data.put("errorCode", errorTraceMessage.getErrorCode());
        data.put("serverEnv", errorTraceMessage.getServerEnv());
        try {
            this.dorisService.send("hera_error_slow_trace", TRACE_ERROR_SLOW_TRACE_COLUMN, data);
        }
        catch (Exception e) {
            log.error("inset erro trace error : ", (Throwable)e);
        }
    }

    public Map<String, Object> buildSpanData(TSpanData tSpanData) {
        HashMap<String, Object> spanData = new HashMap<String, Object>();
        spanData.put("traceID", tSpanData.getTraceId());
        spanData.put("spanID", tSpanData.getSpanId());
        spanData.put("operationName", tSpanData.getName());
        long startTime = tSpanData.getStartEpochNanos();
        spanData.put("startTime", startTime / 1000L);
        spanData.put("startTimeMillis", startTime / 1000000L);
        long duration = tSpanData.getEndEpochNanos() - tSpanData.getStartEpochNanos();
        spanData.put("duration", duration / 1000L);
        spanData.put("references", GSON.toJson(this.buildReferences(tSpanData.getParentSpanContext(), tSpanData.getLinks())));
        spanData.put("tags", GSON.toJson(this.buildAttributes(tSpanData.getAttributes())));
        spanData.put("logs", GSON.toJson(this.buildLogs(tSpanData.getEvents())));
        spanData.put("process", GSON.toJson((Object)this.buildProcess(tSpanData.getExtra().getServiceName(), tSpanData.getResouce())));
        return spanData;
    }

    private List<JaegerReferences> buildReferences(TSpanContext parentSpanContext, List<TLink> links) {
        ArrayList<JaegerReferences> list = new ArrayList<JaegerReferences>();
        if (parentSpanContext != null) {
            JaegerReferences jaegerReferences = new JaegerReferences();
            jaegerReferences.setTraceID(parentSpanContext.getTraceId());
            jaegerReferences.setSpanID(parentSpanContext.getSpanId());
            jaegerReferences.setRefType("CHILD_OF");
            list.add(jaegerReferences);
        }
        return list;
    }

    private List<JaegerLogs> buildLogs(List<TEvent> events) {
        ArrayList<JaegerLogs> list = new ArrayList<JaegerLogs>();
        if (events != null && events.size() > 0) {
            for (TEvent tEvent : events) {
                JaegerLogs log = new JaegerLogs();
                log.setTimestamp(tEvent.getEpochNanos());
                log.setFields(this.buildAttributes(tEvent.getAttributes()));
                list.add(log);
            }
        }
        return list;
    }

    private List<JaegerAttribute> buildAttributes(TAttributes attributes) {
        ArrayList<JaegerAttribute> list = new ArrayList<JaegerAttribute>();
        if (attributes != null && attributes.getKeys() != null && attributes.getKeys().size() > 0) {
            List keys = attributes.getKeys();
            List values = attributes.getValues();
            for (int i = 0; i < keys.size(); ++i) {
                JaegerAttribute attr = new JaegerAttribute();
                TAttributeKey tAttributeKey = (TAttributeKey)keys.get(i);
                attr.setKey(tAttributeKey.getValue());
                switch (tAttributeKey.getType()) {
                    case STRING: {
                        attr.setType("string");
                        attr.setValue(this.decodeLineBreak(((TValue)values.get(i)).getStringValue()));
                        break;
                    }
                    case LONG: {
                        attr.setType("int64");
                        attr.setValue(String.valueOf(((TValue)values.get(i)).getLongValue()));
                        break;
                    }
                    case BOOLEAN: {
                        attr.setType("bool");
                        attr.setValue(String.valueOf(((TValue)values.get(i)).isBoolValue()));
                        break;
                    }
                    case DOUBLE: {
                        attr.setType("float64");
                        attr.setValue(String.valueOf(((TValue)values.get(i)).getDoubleValue()));
                    }
                }
                list.add(attr);
            }
        }
        return list;
    }

    private JaegerProcess buildProcess(String serviceName, TResource resource) {
        JaegerProcess jaegerProcess = new JaegerProcess();
        jaegerProcess.setServiceName(serviceName);
        if (resource != null) {
            jaegerProcess.setTags(this.buildAttributes(resource.getAttributes()));
        }
        return jaegerProcess;
    }

    private String decodeLineBreak(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value.replaceAll("##r'", "\\\\\"").replaceAll("##n", "\\\\n").replaceAll("##r", "\\\\r").replaceAll("##t", "\\\\t").replaceAll("##tat", "\\\\tat").replaceAll("##'", "\\\\\"");
        }
        return value;
    }

    public void insertDriver(DriverDomain driverDomain) {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("type", driverDomain.getType());
            data.put("timestamp", driverDomain.getTimeStamp());
            data.put("appName", driverDomain.getAppName());
            data.put("dataBaseName", driverDomain.getDataBaseName());
            data.put("password", driverDomain.getPassword());
            data.put("domainPort", driverDomain.getDomainPort());
            data.put("userName", driverDomain.getUserName());
            this.dorisService.send("hera_trace_driver", TRACE_DRIVER_COLUMN, data);
        }
        catch (Exception e) {
            log.error("db/redis es data exception:", (Throwable)e);
        }
    }

    public void insertHeraSpan(TSpanData tSpanData, String serviceName, String spanName) {
        try {
            this.insertHeraTraceService(serviceName, spanName);
            Map<String, Object> data = this.buildSpanData(tSpanData);
            this.dorisService.send("hera_trace_span", TRACE_SPAN_COLUMN, data);
        }
        catch (Exception e) {
            log.error("insert hera span error : ", (Throwable)e);
        }
    }
}

