/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.el.opt.arithmetic;

import java.util.Queue;
import org.nutz.el.opt.AbstractOpt;
import org.nutz.el.opt.arithmetic.DivOpt;
import org.nutz.el.opt.arithmetic.LBracketOpt;
import org.nutz.el.opt.arithmetic.ModOpt;
import org.nutz.el.opt.arithmetic.MulOpt;
import org.nutz.el.opt.arithmetic.PlusOpt;
import org.nutz.el.opt.arithmetic.SubOpt;
import org.nutz.el.opt.object.CommaOpt;

public class NegativeOpt
extends AbstractOpt {
    private Object right;

    @Override
    public int fetchPriority() {
        return 2;
    }

    @Override
    public void wrap(Queue<Object> operand) {
        this.right = operand.poll();
    }

    @Override
    public Object calculate() {
        Object rval = this.calculateItem(this.right);
        if (rval instanceof Double) {
            return 0.0 - (Double)rval;
        }
        if (rval instanceof Float) {
            return Float.valueOf(0.0f - ((Float)rval).floatValue());
        }
        if (rval instanceof Long) {
            return 0L - (Long)rval;
        }
        return 0 - (Integer)rval;
    }

    @Override
    public String fetchSelf() {
        return "-";
    }

    public static boolean isNegetive(Object prev) {
        if (prev == null) {
            return true;
        }
        if (prev instanceof Object[]) {
            Object[] tmp = (Object[])prev;
            if (tmp.length == 0) {
                return true;
            }
            prev = tmp[tmp.length - 1];
        }
        if (prev instanceof LBracketOpt) {
            return true;
        }
        if (prev instanceof PlusOpt) {
            return true;
        }
        if (prev instanceof MulOpt) {
            return true;
        }
        if (prev instanceof DivOpt) {
            return true;
        }
        if (prev instanceof ModOpt) {
            return true;
        }
        if (prev instanceof SubOpt) {
            return true;
        }
        return prev instanceof CommaOpt;
    }
}

