/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.nutz.castor.Castors;
import org.nutz.json.JsonField;
import org.nutz.json.TimeStampDateFormat;
import org.nutz.lang.util.NutMap;

public class JsonFormat
extends NutMap {
    private static final long serialVersionUID = 1L;
    private static char DEFAULT_SEPARATOR = (char)34;
    @JsonField(ignore=true)
    private Castors castors;
    public static String DATEFORMAT_TIMESTAMP = "timestamp";

    public static JsonFormat compact() {
        return new JsonFormat(true).setIgnoreNull(true);
    }

    public static JsonFormat full() {
        return new JsonFormat(false).setIgnoreNull(false);
    }

    public static JsonFormat nice() {
        return new JsonFormat(false).setIgnoreNull(true);
    }

    public static JsonFormat forLook() {
        return new JsonFormat(false).setQuoteName(false).setIgnoreNull(true);
    }

    public static JsonFormat tidy() {
        return new JsonFormat(true).setIgnoreNull(false);
    }

    public JsonFormat() {
        this(true);
    }

    public JsonFormat(boolean compact) {
        this.setCompact(compact);
    }

    public boolean ignore(String name) {
        if (null != this.getActived()) {
            return !this.getActived().matcher(name).find();
        }
        if (null != this.getLocked()) {
            return this.getLocked().matcher(name).find();
        }
        return false;
    }

    public boolean isCompact() {
        return this.getBoolean(Function.compact, false);
    }

    public JsonFormat setCompact(boolean compact) {
        this.put(Function.compact, compact);
        return this;
    }

    @Deprecated
    public int getIndent() {
        return 0;
    }

    @Deprecated
    public JsonFormat setIndent(int indent) {
        return this;
    }

    @Deprecated
    public JsonFormat increaseIndent() {
        return this;
    }

    @Deprecated
    public JsonFormat decreaseIndent() {
        return this;
    }

    public String getIndentBy() {
        return this.getString(Function.indentBy, "   ");
    }

    public JsonFormat ignoreJsonShape() {
        this.put(Function.ignoreJsonShape, true);
        return this;
    }

    public boolean isIgnoreJsonShape() {
        return this.getBoolean(Function.ignoreJsonShape);
    }

    public JsonFormat setIndentBy(String indentBy) {
        this.put(Function.indentBy, indentBy);
        return this;
    }

    public boolean isQuoteName() {
        return this.getBoolean(Function.quoteName, true);
    }

    public JsonFormat setQuoteName(boolean quoteName) {
        this.put(Function.quoteName, quoteName);
        return this;
    }

    public boolean isIgnoreNull() {
        return this.getBoolean(Function.ignoreNull, false);
    }

    public JsonFormat setIgnoreNull(boolean ignoreNull) {
        this.put(Function.ignoreNull, ignoreNull);
        return this;
    }

    public JsonFormat setActived(String regex) {
        this.put(Function.actived, Pattern.compile(regex));
        return this;
    }

    public JsonFormat setLocked(String regex) {
        this.put(Function.locked, Pattern.compile(regex));
        return this;
    }

    public Castors getCastors() {
        return this.castors == null ? Castors.me() : this.castors;
    }

    public JsonFormat setCastors(Castors castors) {
        this.castors = castors;
        return this;
    }

    public JsonFormat setSeparator(char separator) {
        this.put(Function.separator, Character.valueOf(separator));
        return this;
    }

    public char getSeparator() {
        Character separator = this.getAs(Function.separator, Character.class);
        if (separator != null) {
            return separator.charValue();
        }
        return DEFAULT_SEPARATOR;
    }

    public JsonFormat setAutoUnicode(boolean autoUnicode) {
        this.put(Function.autoUnicode, autoUnicode);
        return this;
    }

    public boolean isAutoUnicode() {
        return this.getBoolean(Function.autoUnicode, false);
    }

    public boolean isUnicodeLower() {
        return this.getBoolean(Function.unicodeLower, false);
    }

    public JsonFormat setUnicodeLower(boolean unicodeLower) {
        this.put(Function.unicodeLower, unicodeLower);
        return this;
    }

    public JsonFormat setDateFormat(String df) {
        if (df == null) {
            this.remove(Function.dateFormat);
        } else if (DATEFORMAT_TIMESTAMP.equals(df)) {
            this.put(Function.dateFormat, new TimeStampDateFormat());
        } else {
            this.put(Function.dateFormat, new SimpleDateFormat(df));
            this.put(Function.dateFormatRaw, df);
        }
        return this;
    }

    public JsonFormat setDateFormat(DateFormat df) {
        this.put(Function.dateFormat, df);
        return this;
    }

    public DateFormat getDateFormat() {
        DateFormat df = this.getAs(Function.dateFormat, DateFormat.class);
        return df == null ? null : (DateFormat)df.clone();
    }

    public NumberFormat getNumberFormat() {
        NumberFormat nf = this.getAs(Function.numberFormat, NumberFormat.class);
        return nf == null ? null : (NumberFormat)nf.clone();
    }

    public JsonFormat setNumberFormat(NumberFormat numberFormat) {
        this.put(Function.numberFormat, numberFormat);
        return this;
    }

    @Override
    public JsonFormat clone() {
        JsonFormat jf = new JsonFormat();
        jf.putAll(this);
        return jf;
    }

    public Pattern getActived() {
        return this.getAs(Function.actived, Pattern.class);
    }

    public JsonFormat setActived(Pattern actived) {
        this.put(Function.actived, actived);
        return this;
    }

    public Pattern getLocked() {
        return this.getAs(Function.locked, Pattern.class);
    }

    public JsonFormat setLocked(Pattern locked) {
        this.put(Function.locked, locked);
        return this;
    }

    public boolean isNullAsEmtry() {
        return this.getBoolean(Function.nullAsEmtry, false);
    }

    public JsonFormat setNullAsEmtry(boolean nullAsEmtry) {
        this.put(Function.nullAsEmtry, nullAsEmtry);
        return this;
    }

    public TimeZone getTimeZone() {
        return this.getAs(Function.timeZone, TimeZone.class);
    }

    public JsonFormat setTimeZone(TimeZone timeZone) {
        this.put(Function.timeZone, timeZone);
        return this;
    }

    public boolean isNullListAsEmpty() {
        return this.getBoolean(Function.nullListAsEmpty, false);
    }

    public JsonFormat setNullListAsEmpty(boolean nullListAsEmpty) {
        this.put(Function.nullListAsEmpty, nullListAsEmpty);
        return this;
    }

    public boolean isNullStringAsEmpty() {
        return this.getBoolean(Function.nullStringAsEmpty, false);
    }

    public JsonFormat setNullStringAsEmpty(boolean nullStringAsEmpty) {
        this.put(Function.nullStringAsEmpty, nullStringAsEmpty);
        return this;
    }

    public boolean isNullBooleanAsFalse() {
        return this.getBoolean(Function.nullBooleanAsFalse, false);
    }

    public JsonFormat setNullBooleanAsFalse(boolean nullBooleanAsFalse) {
        this.put(Function.nullBooleanAsFalse, nullBooleanAsFalse);
        return this;
    }

    public boolean isNullNumberAsZero() {
        return this.getBoolean(Function.nullNumberAsZero, false);
    }

    public JsonFormat setNullNumberAsZero(boolean nullNumberAsZero) {
        this.put(Function.nullNumberAsZero, nullNumberAsZero);
        return this;
    }

    public JsonFormat setLocale(String locale) {
        this.put(Function.locale, locale);
        return this;
    }

    public String getLocale() {
        return this.getString(Function.locale);
    }

    public String getDateFormatRaw() {
        return this.getString(Function.dateFormatRaw);
    }

    public static class Function {
        public static String ignoreJsonShape = "ignoreJsonShape";
        public static String indentBy = "indentBy";
        public static String compact = "compact";
        public static String quoteName = "quoteName";
        public static String ignoreNull = "ignoreNull";
        public static String actived = "actived";
        public static String locked = "locked";
        public static String castors = "castors";
        public static String separator = "separator";
        public static String autoUnicode = "autoUnicode";
        public static String unicodeLower = "unicodeLower";
        public static String dateFormat = "dateFormat";
        public static String numberFormat = "numberFormat";
        public static String nullAsEmtry = "nullAsEmtry";
        public static String nullListAsEmpty = "nullListAsEmpty";
        public static String nullStringAsEmpty = "nullStringAsEmpty";
        public static String nullBooleanAsFalse = "nullBooleanAsFalse";
        public static String nullNumberAsZero = "nullNumberAsZero";
        public static String timeZone = "timeZone";
        public static String locale = "locale";
        public static String dateFormatRaw = "dateFormatRaw";
    }
}

