/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.castor.Castors;
import org.nutz.castor.FailToCastObjectException;
import org.nutz.conf.NutConf;
import org.nutz.lang.FailToGetValueException;
import org.nutz.lang.FailToSetValueException;
import org.nutz.lang.Invoking;
import org.nutz.lang.Lang;
import org.nutz.lang.MatchType;
import org.nutz.lang.Strings;
import org.nutz.lang.TypeExtractor;
import org.nutz.lang.born.BornContext;
import org.nutz.lang.born.Borning;
import org.nutz.lang.born.BorningException;
import org.nutz.lang.born.Borns;
import org.nutz.lang.eject.EjectByField;
import org.nutz.lang.eject.EjectByGetter;
import org.nutz.lang.eject.Ejecting;
import org.nutz.lang.inject.InjectByField;
import org.nutz.lang.inject.InjectBySetter;
import org.nutz.lang.inject.Injecting;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.Callback3;

public class Mirror<T> {
    static Map<Type, Mirror> mirrorCache = new HashMap<Type, Mirror>();
    protected BornContext<T> emtryArgsBornContext;
    private static final DefaultTypeExtractor defaultTypeExtractor = new DefaultTypeExtractor();
    private Class<T> klass;
    private Type type;
    private TypeExtractor typeExtractor;
    private String _type_id;
    private static final Pattern PTN = Pattern.compile("(<)(.+)(>)");
    private static final Map<Class<?>, Class<?>> TypeMapping2 = new HashMap();

    public static <T> Mirror<T> me(Class<T> classOfT) {
        return null == classOfT ? null : new Mirror<T>(classOfT).setTypeExtractor(defaultTypeExtractor);
    }

    public static <T> Mirror<T> me(T obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Class) {
            return Mirror.me((Class)obj);
        }
        return Mirror.me(obj.getClass());
    }

    public static <T> Mirror<T> me(Class<T> classOfT, TypeExtractor typeExtractor) {
        return null == classOfT ? null : new Mirror<T>(classOfT).setTypeExtractor(typeExtractor == null ? defaultTypeExtractor : typeExtractor);
    }

    public static <T> Mirror<T> me(Type type) {
        if (null == type) {
            return null;
        }
        if (NutConf.USE_MIRROR_CACHE) {
            Mirror<Class<?>> mir = mirrorCache.get(type);
            if (mir == null) {
                mir = Mirror.me(Lang.getTypeClass(type));
                mir.type = type;
                mirrorCache.put(type, mir);
            }
            return mir;
        }
        return Mirror.me(Lang.getTypeClass(type));
    }

    public Mirror<T> setTypeExtractor(TypeExtractor typeExtractor) {
        this.typeExtractor = typeExtractor;
        return this;
    }

    private Mirror(Class<T> classOfT) {
        this.klass = classOfT;
    }

    public Method getGetter(String fieldName) throws NoSuchMethodException {
        return this.getGetter(fieldName, null);
    }

    public Method getGetter(String fieldName, Class<?> returnType) throws NoSuchMethodException {
        String fn = Strings.upperFirst(fieldName);
        String _get = "get" + fn;
        String _is = "is" + fn;
        Method _m = null;
        for (Method method : this.klass.getMethods()) {
            Class<?> mrt;
            if (method.getParameterTypes().length != 0 || null == (mrt = method.getReturnType()) || null != returnType && !returnType.equals(mrt)) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (_get.equals(method.getName())) {
                return method;
            }
            if (_is.equals(method.getName())) {
                if (!Mirror.me(mrt).isBoolean()) {
                    throw new NoSuchMethodException();
                }
                return method;
            }
            if (!fieldName.equals(method.getName())) continue;
            _m = method;
        }
        if (_m != null) {
            return _m;
        }
        throw Lang.makeThrow(NoSuchMethodException.class, "Fail to find getter for [%s]->[%s]", this.klass.getName(), fieldName);
    }

    public Method getGetter(Field field) throws NoSuchMethodException {
        return this.getGetter(field.getName(), field.getType());
    }

    public static void evalGetterSetter(Method method, Callback3<String, Method, Method> callback, Callback<Method> whenError) {
        String name = method.getName();
        Method getter = null;
        Method setter = null;
        if (name.startsWith("get") && method.getParameterTypes().length == 0) {
            name = Strings.lowerFirst(name.substring(3));
            getter = method;
            try {
                setter = method.getDeclaringClass().getMethod("set" + Strings.upperFirst(name), method.getReturnType());
            }
            catch (Exception exception) {}
        } else if (name.startsWith("is") && Mirror.me(method.getReturnType()).isBoolean() && method.getParameterTypes().length == 0) {
            name = Strings.lowerFirst(name.substring(2));
            getter = method;
            try {
                setter = method.getDeclaringClass().getMethod("set" + Strings.upperFirst(name), method.getReturnType());
            }
            catch (Exception exception) {}
        } else if (name.startsWith("set") && method.getParameterTypes().length == 1) {
            name = Strings.lowerFirst(name.substring(3));
            setter = method;
            try {
                getter = method.getDeclaringClass().getMethod("get" + Strings.upperFirst(name), new Class[0]);
            }
            catch (Exception exception) {}
        } else {
            if (null != whenError) {
                whenError.invoke(method);
            }
            return;
        }
        if (null != callback) {
            callback.invoke(name, getter, setter);
        }
    }

    public static void evalGetterSetter(Method method, final String errmsgFormat, Callback3<String, Method, Method> callback) {
        Mirror.evalGetterSetter(method, callback, new Callback<Method>(){

            @Override
            public void invoke(Method method) {
                throw Lang.makeThrow(errmsgFormat, method.getName(), method.getDeclaringClass().getName());
            }
        });
    }

    public Method getSetter(Field field) throws NoSuchMethodException {
        return this.getSetter(field.getName(), field.getType());
    }

    public Method getSetter(String fieldName, Class<?> paramType) throws NoSuchMethodException {
        try {
            String setterName = "set" + Strings.upperFirst(fieldName);
            try {
                return this.klass.getMethod(setterName, paramType);
            }
            catch (Throwable e) {
                try {
                    return this.klass.getMethod(fieldName, paramType);
                }
                catch (Throwable e1) {
                    Class<?> p;
                    Mirror<Class<?>> type = Mirror.me(paramType);
                    for (Method method : this.klass.getMethods()) {
                        if (method.getParameterTypes().length != 1 || !method.getName().equals(setterName) && !method.getName().equals(fieldName) || null != paramType && !type.canCastToDirectly(method.getParameterTypes()[0])) continue;
                        return method;
                    }
                    if (!paramType.isPrimitive() && null != (p = this.unWrapper())) {
                        return this.getSetter(fieldName, p);
                    }
                    throw new RuntimeException();
                }
            }
        }
        catch (Throwable e) {
            throw Lang.makeThrow(NoSuchMethodException.class, "Fail to find setter for [%s]->[%s(%s)]", this.klass.getName(), fieldName, paramType == null ? "" : paramType.getName());
        }
    }

    public Method[] findSetters(String fieldName) {
        String mName = "set" + Strings.upperFirst(fieldName);
        ArrayList<Method> ms = new ArrayList<Method>();
        for (Method m : this.klass.getMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 1 || !m.getName().equals(mName)) continue;
            ms.add(m);
        }
        return ms.toArray(new Method[ms.size()]);
    }

    public Field getField(String name) throws NoSuchFieldException {
        for (Class<T> cc = this.klass; null != cc && cc != Object.class; cc = cc.getSuperclass()) {
            try {
                return cc.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(String.format("Can NOT find field [%s] in class [%s] and it's parents classes", name, this.klass.getName()));
    }

    public <AT extends Annotation> Field getField(Class<AT> ann) throws NoSuchFieldException {
        for (Field field : this.getFields()) {
            if (!field.isAnnotationPresent(ann)) continue;
            return field;
        }
        throw new NoSuchFieldException(String.format("Can NOT find field [@%s] in class [%s] and it's parents classes", ann.getName(), this.klass.getName()));
    }

    public <AT extends Annotation> Field[] getFields(Class<AT> ann) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field f : this.getFields()) {
            if (!f.isAnnotationPresent(ann)) continue;
            fields.add(f);
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public Field[] getFields() {
        return this._getFields(true, false, true, true);
    }

    public Field[] getFields(boolean noStatic, boolean noFinal) {
        return this._getFields(noStatic, false, noFinal, true);
    }

    public Field[] getStaticField(boolean noFinal) {
        return this._getFields(false, true, noFinal, true);
    }

    private Field[] _getFields(boolean noStatic, boolean noMember, boolean noFinal, boolean noInner) {
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        for (Class<T> cc = this.klass; null != cc && cc != Object.class; cc = cc.getSuperclass()) {
            Field[] fs = cc.getDeclaredFields();
            for (int i = 0; i < fs.length; ++i) {
                Field f = fs[i];
                int m = f.getModifiers();
                if (noStatic && Modifier.isStatic(m) || noFinal && Modifier.isFinal(m) || noInner && f.getName().startsWith("this$") || noMember && !Modifier.isStatic(m) || map.containsKey(fs[i].getName())) continue;
                map.put(fs[i].getName(), fs[i]);
            }
        }
        return map.values().toArray(new Field[map.size()]);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annType) {
        A ann;
        Class<T> cc = this.klass;
        do {
            ann = cc.getAnnotation(annType);
            cc = cc.getSuperclass();
        } while (null == ann && null != cc && cc != Object.class);
        return ann;
    }

    public Type[] getGenericsTypes() {
        if (this.type instanceof ParameterizedType) {
            return Lang.getGenericsTypes(this.type);
        }
        return null;
    }

    public Type getGenericsType(int index) {
        Type[] ts = this.getGenericsTypes();
        return ts == null ? null : (ts.length <= index ? null : ts[index]);
    }

    public Method[] getMethods() {
        LinkedList<Method> list = new LinkedList<Method>();
        for (Class<T> cc = this.klass; null != cc && cc != Object.class; cc = cc.getSuperclass()) {
            Method[] ms = cc.getDeclaredMethods();
            for (int i = 0; i < ms.length; ++i) {
                list.add(ms[i]);
            }
        }
        return list.toArray(new Method[list.size()]);
    }

    public Method[] getAllDeclaredMethods(Class<?> top) {
        Class<T> cc = this.klass;
        LinkedHashMap<String, Method> map = new LinkedHashMap<String, Method>();
        while (null != cc && cc != Object.class) {
            Method[] fs = cc.getDeclaredMethods();
            for (int i = 0; i < fs.length; ++i) {
                String key = fs[i].getName() + Mirror.getParamDescriptor(fs[i].getParameterTypes());
                if (map.containsKey(key)) continue;
                map.put(key, fs[i]);
            }
            cc = cc.getSuperclass() == top ? null : cc.getSuperclass();
        }
        return map.values().toArray(new Method[map.size()]);
    }

    public Method[] getAllDeclaredMethodsWithoutTop() {
        return this.getAllDeclaredMethods(Object.class);
    }

    public Method[] getStaticMethods() {
        LinkedList<Method> list = new LinkedList<Method>();
        for (Method m : this.klass.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers())) continue;
            list.add(m);
        }
        return list.toArray(new Method[list.size()]);
    }

    private static RuntimeException makeSetValueException(Class<?> type, String name, Object value, Exception e) {
        if (e instanceof FailToSetValueException) {
            return (FailToSetValueException)e;
        }
        return new FailToSetValueException(String.format("Fail to set value [%s] to [%s]->[%s] because '%s'", value, type.getName(), name, e.getMessage()), e);
    }

    public void setValue(Object obj, Field field, Object value) throws FailToSetValueException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        Class<?> ft = field.getType();
        if (null != value) {
            if (!field.getType().isAssignableFrom(value.getClass())) {
                try {
                    value = Castors.me().castTo(value, field.getType());
                }
                catch (FailToCastObjectException e) {
                    throw Mirror.makeSetValueException(obj.getClass(), field.getName(), value, e);
                }
            }
        } else if (ft.isPrimitive()) {
            value = Boolean.TYPE == ft ? Boolean.valueOf(false) : (Character.TYPE == ft ? (Comparable<Character>)Character.valueOf('\u0000') : (Comparable<Character>)Byte.valueOf((byte)0));
        }
        try {
            this.getSetter(field).invoke(obj, value);
        }
        catch (Exception e1) {
            try {
                field.set(obj, value);
            }
            catch (Exception e) {
                throw Mirror.makeSetValueException(obj.getClass(), field.getName(), value, e);
            }
        }
    }

    public void setValue(Object obj, String fieldName, Object value) throws FailToSetValueException {
        if (null == value) {
            try {
                this.setValue(obj, this.getField(fieldName), null);
            }
            catch (Exception e1) {
                throw Mirror.makeSetValueException(obj.getClass(), fieldName, null, e1);
            }
        }
        try {
            this.getSetter(fieldName, value.getClass()).invoke(obj, value);
        }
        catch (Exception e) {
            try {
                this.setValue(obj, this.getField(fieldName), value);
            }
            catch (Exception e1) {
                throw Mirror.makeSetValueException(obj.getClass(), fieldName, value, e1);
            }
        }
    }

    private static RuntimeException makeGetValueException(Class<?> type, String name, Throwable e) {
        return new FailToGetValueException(String.format("Fail to get value for [%s]->[%s]", type.getName(), name), e);
    }

    public Object getValue(Object obj, Field f) throws FailToGetValueException {
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        try {
            return f.get(obj);
        }
        catch (Exception e) {
            throw Mirror.makeGetValueException(obj.getClass(), f.getName(), e);
        }
    }

    public Object getValue(Object obj, String name) throws FailToGetValueException {
        try {
            return this.getGetter(name).invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            try {
                return this.getValue(obj, this.getField(name));
            }
            catch (NoSuchFieldException e1) {
                if (obj != null) {
                    if (obj.getClass().isArray() && "length".equals(name)) {
                        return Lang.eleSize(obj);
                    }
                    if (obj instanceof Map) {
                        return ((Map)obj).get(name);
                    }
                    if (obj instanceof List) {
                        try {
                            return ((List)obj).get(Integer.parseInt(name));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                throw Mirror.makeGetValueException(obj == null ? this.getType() : obj.getClass(), name, e);
            }
        }
    }

    public Class<T> getType() {
        return this.klass;
    }

    public String getTypeId() {
        if (null == this._type_id) {
            if (null != this.type && this.type instanceof ParameterizedType) {
                ParameterizedType pmType = (ParameterizedType)this.type;
                ArrayList<Type> list = new ArrayList<Type>(pmType.getActualTypeArguments().length);
                for (Type pmA : pmType.getActualTypeArguments()) {
                    list.add(pmA);
                }
                this._type_id = String.format("%s<%s>", this.klass.getName(), Lang.concat((Object)",", list));
            } else {
                this._type_id = this.klass.getName();
            }
            this._type_id = this._type_id + "_" + this.klass.getClassLoader();
        }
        return this._type_id;
    }

    public Type getActuallyType() {
        return this.type == null ? this.klass : this.type;
    }

    public Class<?>[] extractTypes() {
        return this.typeExtractor.extract(this);
    }

    public Class<?> getWrapperClass() {
        if (!this.klass.isPrimitive()) {
            if (this.isPrimitiveNumber() || this.is(Boolean.class) || this.is(Character.class)) {
                return this.klass;
            }
            if (Number.class.isAssignableFrom(this.klass)) {
                return this.klass;
            }
            throw Lang.makeThrow("Class '%s' should be a primitive class", this.klass.getName());
        }
        if (this.is(Integer.TYPE)) {
            return Integer.class;
        }
        if (this.is(Character.TYPE)) {
            return Character.class;
        }
        if (this.is(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (this.is(Long.TYPE)) {
            return Long.class;
        }
        if (this.is(Float.TYPE)) {
            return Float.class;
        }
        if (this.is(Byte.TYPE)) {
            return Byte.class;
        }
        if (this.is(Short.TYPE)) {
            return Short.class;
        }
        if (this.is(Double.TYPE)) {
            return Double.class;
        }
        throw Lang.makeThrow("Class [%s] has no wrapper class!", this.klass.getName());
    }

    public Class<?> getWrapper() {
        if (this.klass.isPrimitive()) {
            return this.getWrapperClass();
        }
        return this.klass;
    }

    public Class<?> getOuterClass() {
        if (Modifier.isStatic(this.klass.getModifiers())) {
            return null;
        }
        String name = this.klass.getName();
        int pos = name.lastIndexOf(36);
        if (pos == -1) {
            return null;
        }
        name = name.substring(0, pos);
        try {
            return Lang.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Borning<T> getBorning(Object ... args) throws BorningException {
        BornContext<T> bc = Borns.eval(this.klass, args);
        if (null == bc) {
            throw new BorningException(this.klass, args);
        }
        return bc.getBorning();
    }

    public Borning<T> getBorningByArgTypes(Class<?> ... argTypes) throws BorningException {
        BornContext<T> bc = Borns.evalByArgTypes(this.klass, argTypes);
        if (null == bc) {
            throw new BorningException(this.klass, argTypes);
        }
        return bc.getBorning();
    }

    public T born(Object ... args) {
        BornContext<T> bc;
        if (NutConf.USE_MIRROR_CACHE && args.length == 0) {
            if (this.emtryArgsBornContext == null) {
                this.emtryArgsBornContext = Borns.eval(this.klass, args);
            }
            bc = this.emtryArgsBornContext;
        } else {
            bc = Borns.eval(this.klass, args);
        }
        if (null == bc) {
            throw new BorningException(this.klass, args);
        }
        return bc.doBorn();
    }

    private static boolean doMatchMethodParamsType(Class<?>[] paramTypes, Class<?>[] methodArgTypes) {
        if (paramTypes.length == 0 && methodArgTypes.length == 0) {
            return true;
        }
        if (paramTypes.length == methodArgTypes.length) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (Mirror.me(paramTypes[i]).canCastToDirectly(methodArgTypes[i])) continue;
                return false;
            }
            return true;
        }
        if (paramTypes.length + 1 == methodArgTypes.length) {
            if (!methodArgTypes[paramTypes.length].isArray()) {
                return false;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                if (Mirror.me(paramTypes[i]).canCastToDirectly(methodArgTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Invoking getInvoking(String methodName, Object ... args) {
        return new Invoking(this.klass, methodName, args);
    }

    public Injecting getInjecting(String fieldName) {
        Method[] sss = this.findSetters(fieldName);
        if (sss.length == 1) {
            return new InjectBySetter(sss[0]);
        }
        try {
            Field field = this.getField(fieldName);
            try {
                return new InjectBySetter(this.getSetter(field));
            }
            catch (NoSuchMethodException e) {
                return new InjectByField(field);
            }
        }
        catch (NoSuchFieldException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public Ejecting getEjecting(String fieldName) {
        return this.getEjecting(fieldName, null);
    }

    public Ejecting getEjecting(Field field) {
        try {
            return new EjectByGetter(this.getGetter(field));
        }
        catch (NoSuchMethodException e1) {
            return new EjectByField(field);
        }
    }

    public Ejecting getEjecting(String fieldName, Class<?> returnType) {
        try {
            return new EjectByGetter(this.getGetter(fieldName, returnType));
        }
        catch (NoSuchMethodException e) {
            try {
                Field field = this.getField(fieldName);
                return this.getEjecting(field);
            }
            catch (NoSuchFieldException e1) {
                throw Lang.wrapThrow(e1);
            }
        }
    }

    public Object invoke(Object obj, String methodName, Object ... args) {
        return this.getInvoking(methodName, args).invoke(obj);
    }

    public Method findMethod(String name, Object[] args) throws NoSuchMethodException {
        if (null == args || args.length == 0) {
            return this.findMethod(name, new Class[0]);
        }
        Class[] paramTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            paramTypes[i] = args[i].getClass();
        }
        return this.findMethod(name, paramTypes);
    }

    public Method findMethod(String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        try {
            return this.klass.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            for (Method m : this.klass.getMethods()) {
                if (!m.getName().equals(name) || !Mirror.doMatchMethodParamsType(paramTypes, m.getParameterTypes())) continue;
                return m;
            }
            Method[] sms = this.getMethods();
            block3: for (Method m : sms) {
                Class<?>[] pts;
                if (!m.getName().equals(name) || (pts = m.getParameterTypes()).length != 1 || !pts[0].isArray()) continue;
                if (paramTypes.length == 0) {
                    return m;
                }
                Class<?> varParam = pts[0].getComponentType();
                for (Class<?> klass : paramTypes) {
                    if (!Castors.me().canCast(klass, varParam)) continue block3;
                }
                return m;
            }
            throw new NoSuchMethodException(String.format("Fail to find Method %s->%s with params:\n%s", this.klass.getName(), name, Castors.me().castToString(paramTypes)));
        }
    }

    public Method[] findMethods(String name, int argNumber) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Method m : this.klass.getMethods()) {
            if (!m.getName().equals(name)) continue;
            if (argNumber < 0) {
                methods.add(m);
                continue;
            }
            if (m.getParameterTypes().length != argNumber) continue;
            methods.add(m);
        }
        return methods.toArray(new Method[methods.size()]);
    }

    public Method findMethod(Class<?> returnType, Class<?> ... paramTypes) throws NoSuchMethodException {
        for (Method m : this.klass.getMethods()) {
            if (returnType != m.getReturnType() || paramTypes.length != m.getParameterTypes().length) continue;
            boolean noThisOne = false;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i] == m.getParameterTypes()[i]) continue;
                noThisOne = true;
                break;
            }
            if (noThisOne) continue;
            return m;
        }
        throw new NoSuchMethodException(String.format("Can not find method in [%s] with return type '%s' and arguemtns \n'%s'!", this.klass.getName(), returnType.getName(), Castors.me().castToString(paramTypes)));
    }

    public static MatchType matchParamTypes(Class<?>[] methodParamTypes, Object ... args) {
        return Mirror.matchParamTypes(methodParamTypes, Mirror.evalToTypes(args));
    }

    public static Class<?>[] evalToTypes(Object ... args) {
        Class[] types = new Class[args.length];
        int i = 0;
        for (Object arg : args) {
            types[i++] = null == arg ? Object.class : arg.getClass();
        }
        return types;
    }

    public static Object evalArgToSameTypeRealArray(Object ... args) {
        Object array = Mirror.evalArgToRealArray(args);
        return array == args ? null : array;
    }

    public static Object evalArgToRealArray(Object ... args) {
        if (null == args || args.length == 0 || null == args[0]) {
            return null;
        }
        Object re = null;
        Class<?> type = null;
        for (Object arg : args) {
            if (null == arg) break;
            if (null == type) {
                type = arg.getClass();
                continue;
            }
            if (arg.getClass() == type) continue;
            type = null;
            break;
        }
        if (type != null) {
            re = Array.newInstance(type, args.length);
            for (int i = 0; i < args.length; ++i) {
                Array.set(re, i, args[i]);
            }
            return re;
        }
        return args;
    }

    public static MatchType matchParamTypes(Class<?>[] paramTypes, Class<?>[] argTypes) {
        int len;
        int n = len = argTypes == null ? 0 : argTypes.length;
        if (len == 0 && paramTypes.length == 0) {
            return MatchType.YES;
        }
        if (paramTypes.length == len) {
            for (int i = 0; i < len; ++i) {
                if (Mirror.me(argTypes[i]).canCastToDirectly(paramTypes[i])) continue;
                return MatchType.NO;
            }
            return MatchType.YES;
        }
        if (len + 1 == paramTypes.length) {
            if (!paramTypes[len].isArray()) {
                return MatchType.NO;
            }
            for (int i = 0; i < len; ++i) {
                if (Mirror.me(argTypes[i]).canCastToDirectly(paramTypes[i])) continue;
                return MatchType.NO;
            }
            return MatchType.LACK;
        }
        return MatchType.NO;
    }

    public boolean is(Class<?> type) {
        return null != type && this.klass == type;
    }

    public boolean is(String className) {
        return this.klass.getName().equals(className);
    }

    public boolean isOf(Class<?> type) {
        return type.isAssignableFrom(this.klass);
    }

    public boolean isString() {
        return this.is(String.class);
    }

    public boolean isStringLike() {
        return CharSequence.class.isAssignableFrom(this.klass);
    }

    public boolean isSimple() {
        return this.isStringLike() || this.isBoolean() || this.isChar() || this.isNumber() || this.isDateTimeLike() || this.isEnum();
    }

    public boolean isChar() {
        return this.is(Character.TYPE) || this.is(Character.class);
    }

    public boolean isEnum() {
        return this.klass.isEnum();
    }

    public boolean isBoolean() {
        return this.is(Boolean.TYPE) || this.is(Boolean.class);
    }

    public boolean isFloat() {
        return this.is(Float.TYPE) || this.is(Float.class);
    }

    public boolean isDouble() {
        return this.is(Double.TYPE) || this.is(Double.class);
    }

    public boolean isInt() {
        return this.is(Integer.TYPE) || this.is(Integer.class);
    }

    public boolean isIntLike() {
        return this.isInt() || this.isLong() || this.isShort() || this.isByte() || this.is(BigDecimal.class);
    }

    public boolean isInterface() {
        return this.klass.isInterface();
    }

    public boolean isDecimal() {
        return this.isFloat() || this.isDouble();
    }

    public boolean isLong() {
        return this.is(Long.TYPE) || this.is(Long.class);
    }

    public boolean isShort() {
        return this.is(Short.TYPE) || this.is(Short.class);
    }

    public boolean isByte() {
        return this.is(Byte.TYPE) || this.is(Byte.class);
    }

    public boolean isWrapperOf(Class<?> type) {
        try {
            return Mirror.me(type).getWrapperClass() == this.klass;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canCastToDirectly(Class<?> type) {
        if (this.klass == type || type.isAssignableFrom(this.klass)) {
            return true;
        }
        if (this.klass.isPrimitive() && type.isPrimitive() && this.isPrimitiveNumber() && Mirror.me(type).isPrimitiveNumber()) {
            return true;
        }
        try {
            return Mirror.me(type).getWrapperClass() == this.getWrapperClass();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isPrimitiveNumber() {
        return this.isInt() || this.isLong() || this.isFloat() || this.isDouble() || this.isByte() || this.isShort();
    }

    public boolean isObj() {
        return this.isContainer() || this.isPojo();
    }

    public boolean isPojo() {
        if (this.klass.isPrimitive() || this.isEnum()) {
            return false;
        }
        if (this.isStringLike() || this.isDateTimeLike()) {
            return false;
        }
        if (this.isPrimitiveNumber() || this.isBoolean() || this.isChar()) {
            return false;
        }
        return !this.isContainer();
    }

    public boolean isContainer() {
        return this.isColl() || this.isMap();
    }

    public boolean isArray() {
        return this.klass.isArray();
    }

    public boolean isCollection() {
        return this.isOf(Collection.class);
    }

    public boolean isColl() {
        return this.isArray() || this.isCollection();
    }

    public boolean isMap() {
        return this.isOf(Map.class);
    }

    public boolean isNumber() {
        return Number.class.isAssignableFrom(this.klass) || this.klass.isPrimitive() && !this.is(Boolean.TYPE) && !this.is(Character.TYPE);
    }

    public boolean isDateTimeLike() {
        return Calendar.class.isAssignableFrom(this.klass) || java.util.Date.class.isAssignableFrom(this.klass) || Date.class.isAssignableFrom(this.klass) || Time.class.isAssignableFrom(this.klass);
    }

    public boolean isLocalDateLike() {
        try {
            return NutConf.HAS_LOCAL_DATE_TIME && this.is(LocalDate.class);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isLocalDateTimeLike() {
        try {
            return NutConf.HAS_LOCAL_DATE_TIME && this.is(LocalDateTime.class);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.klass.getName();
    }

    public static Object blankArrayArg(Class<?>[] pts) {
        return Array.newInstance(pts[pts.length - 1].getComponentType(), 0);
    }

    public static Type[] getTypeParams(Class<?> klass) {
        Type[] interfaces;
        if (klass == null || "java.lang.Object".equals(klass.getName())) {
            return null;
        }
        Type superclass = klass.getGenericSuperclass();
        if (null != superclass && superclass instanceof ParameterizedType) {
            return ((ParameterizedType)superclass).getActualTypeArguments();
        }
        for (Type inf : interfaces = klass.getGenericInterfaces()) {
            if (!(inf instanceof ParameterizedType)) continue;
            return ((ParameterizedType)inf).getActualTypeArguments();
        }
        return Mirror.getTypeParams(klass.getSuperclass());
    }

    public static Class<?>[] getGenericTypes(Field f) {
        String s;
        String[] ss;
        String gts = f.toGenericString();
        Matcher m = PTN.matcher(gts);
        if (m.find() && (ss = Strings.splitIgnoreBlank(s = m.group(2))).length > 0) {
            Class[] re = new Class[ss.length];
            try {
                for (int i = 0; i < ss.length; ++i) {
                    int pos;
                    String className = ss[i];
                    re[i] = className.length() > 0 && className.charAt(0) == '?' ? Object.class : ((pos = className.indexOf(60)) < 0 ? Lang.loadClass(className) : Lang.loadClass(className.substring(0, pos)));
                }
                return re;
            }
            catch (ClassNotFoundException e) {
                throw Lang.wrapThrow(e);
            }
        }
        return new Class[0];
    }

    public static Class<?> getGenericTypes(Field f, int index) {
        Class<?>[] types = Mirror.getGenericTypes(f);
        if (null == types || types.length <= index) {
            return null;
        }
        return types[index];
    }

    public static <T> Class<T> getTypeParam(Class<?> klass, int index) {
        Type[] types = Mirror.getTypeParams(klass);
        if (types == null) {
            return null;
        }
        if (index >= 0 && index < types.length) {
            Type t = types[index];
            Class<?> clazz = Lang.getTypeClass(t);
            if (clazz == null) {
                throw Lang.makeThrow("Type '%s' is not a Class", t.toString());
            }
            return clazz;
        }
        throw Lang.makeThrow("Class type param out of range %d/%d", index, types.length);
    }

    public static String getPath(Class<?> klass) {
        return klass.getName().replace('.', '/');
    }

    public static String getParamDescriptor(Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Class<?> pt : parameterTypes) {
            sb.append(Mirror.getTypeDescriptor(pt));
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getMethodDescriptor(Method method) {
        return Mirror.getParamDescriptor(method.getParameterTypes()) + Mirror.getTypeDescriptor(method.getReturnType());
    }

    public static String getConstructorDescriptor(Constructor<?> c) {
        return Mirror.getParamDescriptor(c.getParameterTypes()) + "V";
    }

    public static String getTypeDescriptor(Class<?> klass) {
        if (klass.isPrimitive()) {
            if (klass == Void.TYPE) {
                return "V";
            }
            if (klass == Integer.TYPE) {
                return "I";
            }
            if (klass == Long.TYPE) {
                return "J";
            }
            if (klass == Byte.TYPE) {
                return "B";
            }
            if (klass == Short.TYPE) {
                return "S";
            }
            if (klass == Float.TYPE) {
                return "F";
            }
            if (klass == Double.TYPE) {
                return "D";
            }
            if (klass == Character.TYPE) {
                return "C";
            }
            return "Z";
        }
        StringBuilder sb = new StringBuilder();
        if (klass.isArray()) {
            return sb.append('[').append(Mirror.getTypeDescriptor(klass.getComponentType())).toString();
        }
        return sb.append('L').append(Mirror.getPath(klass)).append(';').toString();
    }

    public static Field findField(Class<?> type, Class<? extends Annotation> ann) {
        Mirror<Class<?>> mirror = Mirror.me(type);
        for (Field f : mirror.getFields()) {
            if (!f.isAnnotationPresent(ann)) continue;
            return f;
        }
        return null;
    }

    public Class<?> unWrapper() {
        return TypeMapping2.get(this.klass);
    }

    public boolean hasInterface(Class<?> clzInterface) {
        Class<?>[] interfaces = this.klass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!clzInterface.equals(interfaces[i])) continue;
            return true;
        }
        return false;
    }

    public static <T extends Annotation> T getAnnotationDeep(Method method, Class<T> annotationClass) {
        T t = method.getAnnotation(annotationClass);
        if (t != null) {
            return t;
        }
        for (Class<?> klass = method.getDeclaringClass().getSuperclass(); klass != null && klass != Object.class; klass = klass.getSuperclass()) {
            try {
                for (GenericDeclaration genericDeclaration : klass.getMethods()) {
                    Class<?>[] methodParameters;
                    Class<?>[] mParameters;
                    if (!((Method)genericDeclaration).getName().equals(method.getName()) || (mParameters = ((Method)genericDeclaration).getParameterTypes()).length != (methodParameters = method.getParameterTypes()).length) continue;
                    boolean match = true;
                    for (int i = 0; i < mParameters.length; ++i) {
                        if (mParameters[i].isAssignableFrom(methodParameters[i])) continue;
                        match = false;
                        break;
                    }
                    if (!match || (t = ((Method)genericDeclaration).getAnnotation(annotationClass)) == null) continue;
                    return t;
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (GenericDeclaration genericDeclaration : method.getDeclaringClass().getInterfaces()) {
            try {
                Method tmp = ((Class)genericDeclaration).getMethod(method.getName(), method.getParameterTypes());
                t = tmp.getAnnotation(annotationClass);
                if (t == null) continue;
                return t;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotationDeep(Class<?> type, Class<T> annotationClass) {
        T t;
        Class<?> cc = type;
        do {
            t = cc.getAnnotation(annotationClass);
            cc = cc.getSuperclass();
        } while (null == t && cc != Object.class);
        if (t != null) {
            return t;
        }
        for (Class<?> klass : type.getInterfaces()) {
            try {
                t = klass.getAnnotation(annotationClass);
                if (t == null) continue;
                return t;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isAnnotationExists(Method method, Class<? extends Annotation> ... classes) {
        if (!Lang.isEmptyArray(classes)) {
            for (Class<? extends Annotation> klass : classes) {
                if (Mirror.getAnnotationDeep(method, klass) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotationExists(Class<?> type, Class<? extends Annotation> ... classes) {
        if (!Lang.isEmptyArray(classes)) {
            for (Class<? extends Annotation> klass : classes) {
                if (Mirror.getAnnotationDeep(type, klass) == null) continue;
                return true;
            }
        }
        return false;
    }

    static {
        TypeMapping2.put(Short.class, Short.TYPE);
        TypeMapping2.put(Integer.class, Integer.TYPE);
        TypeMapping2.put(Long.class, Long.TYPE);
        TypeMapping2.put(Double.class, Double.TYPE);
        TypeMapping2.put(Float.class, Float.TYPE);
        TypeMapping2.put(Byte.class, Byte.TYPE);
        TypeMapping2.put(Character.class, Character.TYPE);
        TypeMapping2.put(Boolean.class, Boolean.TYPE);
    }

    private static class DefaultTypeExtractor
    implements TypeExtractor {
        private DefaultTypeExtractor() {
        }

        @Override
        public Class<?>[] extract(Mirror<?> mirror) {
            Class<?> theType = mirror.getType();
            ArrayList re = new ArrayList(5);
            if (theType.isPrimitive()) {
                re.add(mirror.getWrapperClass());
                if (theType != Boolean.TYPE && theType != Character.TYPE) {
                    re.add(Number.class);
                }
            } else if (mirror.isOf(Calendar.class)) {
                re.add(Calendar.class);
            } else {
                re.add(theType);
                if (((Mirror)mirror).klass.isEnum()) {
                    re.add(Enum.class);
                } else if (((Mirror)mirror).klass.isArray()) {
                    re.add(Array.class);
                } else if (mirror.isStringLike()) {
                    re.add(CharSequence.class);
                } else if (mirror.isNumber()) {
                    re.add(Number.class);
                } else if (mirror.isOf(Map.class)) {
                    re.add(Map.class);
                } else if (mirror.isOf(List.class)) {
                    re.add(List.class);
                    re.add(Collection.class);
                } else if (mirror.isOf(Collection.class)) {
                    re.add(Collection.class);
                }
            }
            if (theType != Object.class) {
                re.add(Object.class);
            }
            return re.toArray(new Class[re.size()]);
        }
    }
}

