/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Streams;
import org.nutz.lang.born.Borning;
import org.nutz.lang.socket.CloseSocketException;
import org.nutz.lang.socket.SocketAction;
import org.nutz.lang.socket.SocketActionTable;
import org.nutz.lang.socket.SocketAtom;
import org.nutz.lang.socket.SocketContext;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class Sockets {
    private static final Log log = Logs.get();
    private static final int DEFAULT_POOL_SIZE = 10;

    public static void send(String host, int port, InputStream ins, OutputStream ops) {
        Sockets.send(host, port, ins, ops, 0);
    }

    public static void send(String host, int port, InputStream ins, OutputStream ops, int timeout) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout);
            OutputStream sOut = socket.getOutputStream();
            Streams.write(sOut, ins);
            sOut.flush();
            if (!socket.isClosed()) {
                InputStream sReturn = socket.getInputStream();
                Streams.write(ops, sReturn);
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(ins);
            Streams.safeClose(ops);
            Sockets.safeClose(socket);
        }
    }

    public static String sendText(String host, int port, String text) {
        StringBuilder sb = new StringBuilder();
        Sockets.send(host, port, Lang.ins(text), Lang.ops(sb));
        return sb.toString();
    }

    public static void localListenOneAndStop(int port, String line, SocketAction action) {
        Map<String, SocketAction> actions = Sockets.createActions();
        actions.put(line, action);
        actions.put("$:^(close|stop|bye|exit)$", Sockets.doClose());
        Sockets.localListenByLine(port, actions);
    }

    public static void localListenOne(int port, String line, SocketAction action) {
        Map<String, SocketAction> actions = Sockets.createActions();
        actions.put(line, action);
        Sockets.localListenByLine(port, actions);
    }

    public static void localListenByLine(int port, Map<String, SocketAction> actions) {
        Sockets.localListenByLine(port, actions, 10);
    }

    public static void localListenByLine(int port, Map<String, SocketAction> actions, int poolSize) {
        Sockets.localListenByLine(port, actions, Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * poolSize));
    }

    public static void localListenByLine(int port, Map<String, SocketAction> actions, ExecutorService service) {
        Sockets.localListen(port, actions, service, SocketAtom.class);
    }

    public static void localListen(int port, Map<String, SocketAction> actions, ExecutorService service, Class<? extends SocketAtom> klass) {
        try {
            ServerSocket server;
            SocketActionTable saTable = new SocketActionTable(actions);
            try {
                server = new ServerSocket(port);
            }
            catch (IOException e1) {
                throw Lang.wrapThrow(e1);
            }
            if (log.isInfoEnabled()) {
                log.infof("Local socket is up at :%d with %d action ready", port, actions.size());
            }
            final Context context = Lang.context();
            context.set("stop", false);
            new Thread(){

                @Override
                public void run() {
                    this.setName("Nutz.Sockets monitor thread");
                    while (true) {
                        try {
                            do {
                                Thread.sleep(1000L);
                            } while (!context.getBoolean("stop"));
                            try {
                                server.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            continue;
                        }
                        break;
                    }
                }
            }.start();
            Borning<Class<? extends SocketAtom>> borning = Mirror.me(klass).getBorningByArgTypes(Context.class, Socket.class, SocketActionTable.class);
            if (borning == null) {
                log.error("boring == null !!!!");
                return;
            }
            while (!context.getBoolean("stop")) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Waiting for new socket");
                    }
                    Socket socket = server.accept();
                    if (context.getBoolean("stop")) {
                        Sockets.safeClose(socket);
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("accept a new socket, create new SocketAtom to handle it ...");
                    }
                    Runnable runnable = (Runnable)((Object)borning.born(context, socket, saTable));
                    service.execute(runnable);
                }
                catch (Throwable e) {
                    log.info("Throwable catched!! maybe ask to exit", e);
                }
            }
            if (!server.isClosed()) {
                try {
                    server.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            log.info("Seem stop signal was got, wait 15 for all running thread");
            try {
                service.shutdown();
                service.awaitTermination(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                service.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (log.isInfoEnabled()) {
                log.info("Stop services ...");
            }
            service.shutdown();
        }
        if (log.isInfoEnabled()) {
            log.infof("Local socket is down for :%d", port);
        }
    }

    public static Socket safeClose(Socket socket) {
        if (null != socket) {
            try {
                socket.close();
                socket = null;
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
        return null;
    }

    public static SocketAction doClose() {
        return new SocketAction(){

            @Override
            public void run(SocketContext context) {
                throw new CloseSocketException();
            }
        };
    }

    public static void close() {
        throw new CloseSocketException();
    }

    public static Map<String, SocketAction> createActions() {
        return new HashMap<String, SocketAction>();
    }
}

