/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends InputStream {
    private RandomAccessFile raf;

    public RandomAccessFileInputStream(RandomAccessFile raf) {
        this.raf = raf;
    }

    @Override
    public int read() throws IOException {
        return this.raf.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.raf.skipBytes((int)n);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.raf.seek(0L);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return super.read(b);
    }

    @Override
    public int available() throws IOException {
        return (int)(this.raf.length() - this.raf.getFilePointer());
    }
}

