/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor.injector;

import java.util.LinkedHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.castor.Castors;
import org.nutz.mvc.adaptor.ParamInjector;

public class CookieInjector
implements ParamInjector {
    private String name;
    private Class<?> type;

    public CookieInjector(String name, Class<?> type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public Object get(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, Object refer) {
        Cookie[] _cookies = req.getCookies();
        if (_cookies == null) {
            _cookies = new Cookie[]{};
        }
        if ("_map".equals(this.name)) {
            LinkedHashMap<String, String> cookies = new LinkedHashMap<String, String>();
            for (Cookie cookie : _cookies) {
                cookies.put(cookie.getName(), cookie.getValue());
            }
            return cookies;
        }
        for (Cookie cookie : _cookies) {
            if (!cookie.getName().equalsIgnoreCase(this.name)) continue;
            return Castors.me().castTo(cookie.getValue(), this.type);
        }
        return null;
    }
}

