/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.upload;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nutz.filepool.FilePool;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.upload.FieldMeta;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadException;
import org.nutz.mvc.upload.UploadOutOfSizeException;
import org.nutz.mvc.upload.UploadUnsupportedFileNameException;
import org.nutz.mvc.upload.UploadUnsupportedFileTypeException;
import org.nutz.mvc.upload.Uploading;
import org.nutz.mvc.upload.UploadingContext;
import org.nutz.mvc.upload.Uploads;

public class Html5Uploading
implements Uploading {
    private static final Log log = Logs.get();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> parse(HttpServletRequest req, UploadingContext context) throws UploadException, UploadOutOfSizeException, UploadUnsupportedFileNameException, UploadUnsupportedFileTypeException {
        NutMap nutMap;
        int bufferSize = context.getBufferSize();
        int size = req.getContentLength();
        int maxSize = context.getMaxFileSize();
        FilePool tmps = context.getFilePool();
        FieldMeta meta = new FieldMeta("name=\"filedata\"; filename=\"nutz.jpg\"");
        if (maxSize > 0 && size > context.getMaxFileSize()) {
            throw new UploadOutOfSizeException(meta);
        }
        String disposition = req.getHeader("Content-Disposition");
        if (disposition != null && disposition.startsWith("attachment;")) {
            meta = new FieldMeta(disposition.substring("attachment;".length()).trim());
        } else if (log.isInfoEnabled()) {
            log.info("Content-Disposition no found, using default fieldname=filedata, filename=nutz.jpg");
        }
        if (log.isDebugEnabled()) {
            log.debugf("Upload File info: FilePath=[%s],fieldName=[%s]", meta.getFileLocalPath(), meta.getName());
        }
        if (!context.isNameAccepted(meta.getFileLocalName())) {
            throw new UploadUnsupportedFileNameException(meta);
        }
        File tmp = tmps.createFile(meta.getFileExtension());
        BufferedOutputStream ops = null;
        try {
            ops = new BufferedOutputStream(new FileOutputStream(tmp), bufferSize * 2);
            Streams.writeAndClose((OutputStream)ops, (InputStream)req.getInputStream());
            if (tmp.length() != (long)size) {
                throw new UploadOutOfSizeException(meta);
            }
            if (maxSize > 0 && tmp.length() > (long)maxSize) {
                throw new UploadOutOfSizeException(meta);
            }
            NutMap params = Uploads.createParamsMap(req);
            if (tmp.length() == 0L && context.isIgnoreNull()) {
                if (log.isDebugEnabled()) {
                    log.debug("emtry file , drop it ~~");
                }
                tmp.delete();
            } else {
                params.put(meta.getName(), new TempFile(meta, tmp));
            }
            nutMap = params;
        }
        catch (FileNotFoundException e) {
            try {
                throw Lang.wrapThrow(e);
                catch (IOException e2) {
                    throw Lang.wrapThrow(e2);
                }
            }
            catch (Throwable throwable) {
                Streams.safeClose(ops);
                throw throwable;
            }
        }
        Streams.safeClose(ops);
        return nutMap;
    }
}

