/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class FreeMarkerUtil {
    private static Template getTemplate(String name, String pathPrefix) throws IOException {
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(FreeMarkerUtil.class, pathPrefix);
        cfg.setDefaultEncoding("UTF-8");
        Template temp = cfg.getTemplate(name);
        return temp;
    }

    public static String getContent(String pathPrefix, String name, Map<String, Object> rootMap) throws TemplateException, IOException {
        StringWriter writer = new StringWriter();
        FreeMarkerUtil.getTemplate(name, pathPrefix).process(rootMap, (Writer)writer);
        String jsonStr = writer.toString();
        JsonObject returnData = new JsonParser().parse(jsonStr).getAsJsonObject();
        return returnData.toString();
    }

    public static String getContentExceptJson(String pathPrefix, String name, Map<String, Object> rootMap) throws TemplateException, IOException {
        StringWriter writer = new StringWriter();
        FreeMarkerUtil.getTemplate(name, pathPrefix).process(rootMap, (Writer)writer);
        String str = writer.toString();
        return str;
    }

    public static void printFile(String pathPrefix, String name, Map<String, Object> rootMap, File file) throws TemplateException, IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        FreeMarkerUtil.getTemplate(name, pathPrefix).process(rootMap, (Writer)out);
        if (null != out) {
            ((Writer)out).close();
        }
    }

    public static String freemarkerProcess(Map input, String templateStr) {
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        String template = "content";
        stringLoader.putTemplate(template, templateStr);
        Configuration cfg = new Configuration();
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        try {
            Template templateCon = cfg.getTemplate(template);
            StringWriter writer = new StringWriter();
            templateCon.process((Object)input, (Writer)writer);
            return writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getTemplateStr(String pathPrefix, String name) throws IOException {
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(FreeMarkerUtil.class, pathPrefix);
        cfg.setDefaultEncoding("UTF-8");
        Template temp = cfg.getTemplate(name);
        return temp.toString();
    }
}

