/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.mybatisplus.interceptor;

import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DoceanInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DoceanInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler target = (StatementHandler)invocation.getTarget();
        BoundSql sql = target.getBoundSql();
        log.info("sql:{}  ->  {}", (Object)sql.getSql(), sql.getParameterObject());
        Object res = invocation.proceed();
        return res;
    }

    public Object plugin(Object target) {
        Object wrap = Plugin.wrap((Object)target, (Interceptor)this);
        return wrap;
    }

    public void setProperties(Properties properties) {
        log.info("plugin setProperties:{}", (Object)properties);
    }
}

