/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.spring;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.regex.Pattern;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.AbstractJsonHttpMessageConverter;

public class NutzJsonMessageConverter
extends AbstractJsonHttpMessageConverter {
    JsonFormat format = JsonFormat.compact();
    Pattern ignoreType;

    public NutzJsonMessageConverter setIgnoreType(String ignoreType) {
        if (Strings.isBlank((CharSequence)ignoreType)) {
            return this;
        }
        this.ignoreType = Pattern.compile(ignoreType);
        return this;
    }

    public NutzJsonMessageConverter setFormat(JsonFormat format) {
        this.format = format;
        return this;
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        if (Pattern.matches(".*springfox.*", clazz.getName()) || Pattern.matches(".*springfox.*", type.getTypeName())) {
            return false;
        }
        if (Pattern.matches("org.springframework.*", clazz.getName()) || Pattern.matches("org.springframework.*", type.getTypeName())) {
            return false;
        }
        return this.ignoreType == null || !this.ignoreType.matcher(clazz.getName()).matches();
    }

    protected Object readInternal(Type resolvedType, Reader reader) throws Exception {
        return Json.fromJson((Type)resolvedType, (Reader)reader);
    }

    protected void writeInternal(Object o, Type type, Writer writer) throws Exception {
        Json.toJson((Writer)writer, (Object)o, (JsonFormat)this.format);
    }
}

