/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson2.JSONReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.TimeZone;

public class JSONReader
implements Closeable {
    private final Reader input;
    private final com.alibaba.fastjson2.JSONReader raw;

    public JSONReader(Reader reader) {
        this(reader, new Feature[0]);
    }

    public JSONReader(Reader input, Feature ... features) {
        JSONReader.Context context = JSON.createReadContext(JSON.DEFAULT_PARSER_FEATURE, features);
        this.raw = com.alibaba.fastjson2.JSONReader.of((Reader)input, (JSONReader.Context)context);
        this.input = input;
        for (Feature feature : features) {
            if (feature != Feature.SupportArrayToBean) continue;
            context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportArrayToBean});
        }
    }

    public void setLocale(Locale locale) {
        this.raw.getContext().setLocale(locale);
    }

    public void setTimzeZone(TimeZone timezone) {
        this.raw.getContext().setTimeZone(timezone);
    }

    public <T> T readObject(Class<T> type) {
        this.raw.nextIfMatch(':');
        try {
            return (T)this.raw.read(type);
        }
        catch (com.alibaba.fastjson2.JSONException ex) {
            throw new JSONException(ex.getMessage(), ex.getCause());
        }
    }

    public Object readObject() {
        this.raw.nextIfMatch(':');
        return this.raw.readAny();
    }

    public void readObject(Object object) {
        this.raw.nextIfMatch(':');
        this.raw.readObject(object, new JSONReader.Feature[0]);
    }

    public Integer readInteger() {
        this.raw.nextIfMatch(':');
        return this.raw.readInt32();
    }

    public Long readLong() {
        this.raw.nextIfMatch(':');
        return this.raw.readInt64();
    }

    public String readString() {
        this.raw.nextIfMatch(':');
        return this.raw.readString();
    }

    public boolean hasNext() {
        if (this.raw.isEnd()) {
            return false;
        }
        char ch = this.raw.current();
        return ch != ']' && ch != '}';
    }

    public void startArray() {
        this.raw.nextIfMatch(':');
        if (!this.raw.nextIfMatch('[')) {
            throw new JSONException("not support operation");
        }
    }

    public void endArray() {
        if (!this.raw.nextIfMatch(']')) {
            throw new JSONException("not support operation");
        }
        this.raw.nextIfMatch(',');
    }

    public void startObject() {
        this.raw.nextIfMatch(':');
        if (!this.raw.nextIfMatch('{')) {
            throw new JSONException("not support operation");
        }
    }

    public void endObject() {
        if (!this.raw.nextIfMatch('}')) {
            throw new JSONException(this.raw.info("not support operation"));
        }
        this.raw.nextIfMatch(',');
    }

    public Locale getLocal() {
        return this.raw.getContext().getLocale();
    }

    public TimeZone getTimeZone() {
        return this.raw.getContext().getTimeZone();
    }

    public void config(Feature feature, boolean state) {
        JSONReader.Feature rawFeature = null;
        switch (feature) {
            case SupportArrayToBean: {
                rawFeature = JSONReader.Feature.SupportArrayToBean;
                break;
            }
            case UseNativeJavaObject: {
                rawFeature = JSONReader.Feature.UseNativeObject;
                break;
            }
            case SupportAutoType: {
                rawFeature = JSONReader.Feature.SupportAutoType;
                break;
            }
        }
        if (rawFeature == null) {
            return;
        }
        this.raw.getContext().config(rawFeature, state);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

