/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.filter;

import com.xiaomi.mone.tpc.login.enums.UserTypeEnum;
import com.xiaomi.mone.tpc.login.filter.AuthCasFilter;
import com.xiaomi.mone.tpc.login.filter.AuthTokenFilter;
import com.xiaomi.mone.tpc.login.util.GsonUtil;
import com.xiaomi.mone.tpc.login.util.TokenUtil;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.mone.tpc.login.vo.ResultVo;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReqUserFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(HttpReqUserFilter.class);
    private Filter casFilter = null;
    private Filter tokenFilter = null;
    private Filter hermesFilter = null;
    private boolean devMode;
    private boolean innerAuth;
    private String userInfoPath;
    private String logoutUrl;
    private String loginUrl;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.logoutUrl = filterConfig.getInitParameter("logoutUrl");
        this.loginUrl = filterConfig.getInitParameter("loginUrl");
        this.devMode = Boolean.parseBoolean(filterConfig.getInitParameter("devMode"));
        this.innerAuth = Boolean.parseBoolean(filterConfig.getInitParameter("innerAuth"));
        this.userInfoPath = filterConfig.getInitParameter("userInfoPath");
        if (StringUtils.isBlank((CharSequence)this.userInfoPath)) {
            this.userInfoPath = "/login/userinfo";
        }
        if (this.innerAuth) {
            this.casFilter = new AuthCasFilter();
            this.casFilter.init(filterConfig);
        } else {
            this.tokenFilter = new AuthTokenFilter();
            this.tokenFilter.init(filterConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(final ServletRequest var1, final ServletResponse var2, final FilterChain var3) throws IOException, ServletException {
        if (this.devMode) {
            Object mockAccType;
            String mockAcc = ((HttpServletRequest)var1).getHeader("user");
            if (StringUtils.isBlank((CharSequence)mockAcc)) {
                mockAcc = "test";
            }
            if (StringUtils.isBlank((CharSequence)(mockAccType = ((HttpServletRequest)var1).getHeader("userType")))) {
                mockAccType = "" + UserTypeEnum.CAS_TYPE.getCode();
            }
            try {
                AuthUserVo authUserVo = new AuthUserVo();
                authUserVo.setUserType(Integer.parseInt((String)mockAccType));
                authUserVo.setAccount(mockAcc);
                authUserVo.setName(mockAcc);
                UserUtil.setUser(authUserVo);
                if (this.isUserRequest(var1)) {
                    this.writeUserResponse(var2);
                    return;
                }
                var3.doFilter(var1, var2);
            }
            finally {
                UserUtil.clearUser();
            }
            return;
        }
        FilterChain chain = new FilterChain(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                AuthUserVo userInfo = (AuthUserVo)servletRequest.getAttribute("TPC_USER");
                if (userInfo == null) {
                    var3.doFilter(servletRequest, servletResponse);
                    return;
                }
                try {
                    UserUtil.setUser(userInfo);
                    if (HttpReqUserFilter.this.isUserRequest(var1)) {
                        HttpReqUserFilter.this.writeUserResponse(var2);
                        return;
                    }
                    if (HttpReqUserFilter.this.hermesFilter != null) {
                        HttpReqUserFilter.this.hermesFilter.doFilter(servletRequest, servletResponse, var3);
                    } else {
                        var3.doFilter(servletRequest, servletResponse);
                    }
                }
                finally {
                    UserUtil.clearUser();
                }
            }
        };
        if (this.innerAuth) {
            this.casFilter.doFilter(var1, var2, chain);
        } else {
            this.tokenFilter.doFilter(var1, var2, chain);
        }
    }

    private boolean isUserRequest(ServletRequest request) {
        String url = ((HttpServletRequest)request).getRequestURI();
        return url.equals(this.userInfoPath);
    }

    private void writeUserResponse(ServletResponse var2) throws IOException {
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            return;
        }
        userInfo.setLoginUrl(this.loginUrl);
        if (UserTypeEnum.CAS_TYPE.getCode().equals(userInfo.getUserType())) {
            userInfo.setLogoutUrl(this.logoutUrl);
        } else {
            userInfo.setLogoutUrl(TokenUtil.getLogoutUrlWithToken(userInfo.getToken(), this.logoutUrl));
        }
        log.info("writeUserResponse.userInfo={}", (Object)userInfo);
        ResultVo<AuthUserVo> userResult = new ResultVo<AuthUserVo>();
        userResult.setData(userInfo);
        userResult.setCode(0);
        userResult.setMessage("ok");
        var2.setCharacterEncoding("UTF-8");
        var2.setContentType("application/json;charset=utf-8");
        var2.getWriter().write(GsonUtil.gsonString(userResult));
    }

    public void destroy() {
        if (this.casFilter != null) {
            this.casFilter.destroy();
        }
        if (this.tokenFilter != null) {
            this.tokenFilter.destroy();
        }
        if (this.hermesFilter != null) {
            this.hermesFilter.destroy();
        }
    }
}

