/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.config;

import com.xiaomi.youpin.docean.common.EnvUtils;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private Properties properties;

    public Config() {
        String configName = EnvUtils.getEnvOrProperty((String)"docean.config.name", (String)"config.properties");
        InputStream is = Config.class.getClassLoader().getResourceAsStream(configName);
        this.properties = new Properties();
        if (null != is) {
            try {
                this.properties.load(is);
            }
            catch (Exception e) {
                log.warn("load config error:{}", (Object)e.getMessage());
            }
        }
    }

    public void put(String key, String value) {
        this.properties.put(key, value);
    }

    public String get(String key, String defaultValue) {
        return this.properties.getOrDefault((Object)key, defaultValue).toString().trim();
    }

    public Map<String, String> getByPrefix(String prefix, boolean trimPrefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String propName = (String)en.nextElement();
            String propValue = this.properties.getProperty(propName);
            if (!propName.startsWith(prefix)) continue;
            if (trimPrefix) {
                propName = propName.substring(prefix.length());
            }
            result.put(propName, propValue);
        }
        return result;
    }

    public void forEach(BiConsumer<Object, Object> consumer) {
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)consumer);
    }
}

