/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.utils.FieldUtils;

public class StringConstantFieldValuePredicate
implements Predicate<String> {
    private final Set<String> constantFieldValues;

    public StringConstantFieldValuePredicate(Class<?> targetClass) {
        this.constantFieldValues = this.getConstantFieldValues(targetClass);
    }

    public static Predicate<String> of(Class<?> targetClass) {
        return new StringConstantFieldValuePredicate(targetClass);
    }

    private Set<String> getConstantFieldValues(Class<?> targetClass) {
        return Stream.of(targetClass.getFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> Modifier.isPublic(f.getModifiers())).filter(f -> Modifier.isFinal(f.getModifiers())).map(this::getConstantValue).filter(v -> v instanceof String).map(String.class::cast).collect(Collectors.toSet());
    }

    @Override
    public boolean test(String s) {
        return this.constantFieldValues.contains(s);
    }

    private Object getConstantValue(Field field) {
        return FieldUtils.getFieldValue(null, field);
    }
}

