/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import com.alibaba.dubbo.rpc.service.GenericException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.dubbo.common.beanutil.JavaBeanAccessor;
import org.apache.dubbo.common.beanutil.JavaBeanDescriptor;
import org.apache.dubbo.common.beanutil.JavaBeanSerializeUtil;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.io.UnsafeByteArrayInputStream;
import org.apache.dubbo.common.io.UnsafeByteArrayOutputStream;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.gson.IntTypeAdapter;
import org.apache.dubbo.rpc.gson.LongTypeAdapter;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

@Activate(group={"provider"}, order=-20000)
public class GenericFilter
implements Filter,
Filter.Listener {
    private static final Logger logger = LoggerFactory.getLogger(GenericFilter.class);
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(Integer.TYPE, (Object)new IntTypeAdapter()).registerTypeAdapter(Integer.class, (Object)new IntTypeAdapter()).registerTypeAdapter(Long.TYPE, (Object)new LongTypeAdapter()).registerTypeAdapter(Long.class, (Object)new LongTypeAdapter()).create();

    @Override
    public Result invoke(Invoker<?> invoker, Invocation inv) throws RpcException {
        if ((inv.getMethodName().equals("$invoke") || inv.getMethodName().equals("$invokeAsync")) && inv.getArguments() != null && inv.getArguments().length == 3 && !GenericService.class.isAssignableFrom(invoker.getInterface())) {
            String name = ((String)inv.getArguments()[0]).trim();
            String[] types = (String[])inv.getArguments()[1];
            Object[] args = (Object[])inv.getArguments()[2];
            try {
                Method method;
                block34: {
                    method = ReflectUtils.findMethodByMethodSignature(invoker.getInterface(), name, types);
                    Class<?>[] params = method.getParameterTypes();
                    if (args == null) {
                        args = new Object[params.length];
                    }
                    if (types == null) {
                        types = new String[params.length];
                    }
                    if (args.length != types.length) {
                        throw new RpcException("GenericFilter#invoke args.length != types.length, please check your params");
                    }
                    String generic = inv.getAttachment("generic");
                    String protoVersion = inv.getAttachment("youpin_protocol_version", "v1");
                    if (StringUtils.isBlank(generic)) {
                        generic = RpcContext.getContext().getAttachment("generic");
                    }
                    if (StringUtils.isEmpty(generic) || ProtocolUtils.isDefaultGenericSerialization(generic) || ProtocolUtils.isGenericReturnRawResult(generic)) {
                        try {
                            args = PojoUtils.realize(args, params, method.getGenericParameterTypes());
                        }
                        catch (IllegalArgumentException e) {
                            throw new RpcException(e);
                        }
                    }
                    if (ProtocolUtils.isGsonGenericSerialization(generic)) {
                        String newGson = RpcContext.getContext().getAttachment("gson_generic_args");
                        if (!protoVersion.equals("v4")) {
                            args = Boolean.TRUE.toString().equals(newGson) ? this.getGsonGenericArgs(args, method.getGenericParameterTypes()) : this.getArgs(args, method, args);
                        }
                    } else {
                        if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                            String notice = "Trigger the safety barrier! Native Java Serializer is not allowed by default.This means currently maybe being attacking by others. If you are sure this is a mistake, please set `dubbo.security.serialize.generic.native-java-enable` enable in configuration! Before doing so, please make sure you have configure JEP290 to prevent serialization attack.";
                            logger.error(notice);
                            throw new RpcException(new IllegalStateException(notice));
                        }
                        if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                            for (int i = 0; i < args.length; ++i) {
                                if (!(args[i] instanceof JavaBeanDescriptor)) {
                                    throw new RpcException("Generic serialization [bean] only support message type " + JavaBeanDescriptor.class.getName() + " and your message type is " + args[i].getClass().getName());
                                }
                                args[i] = JavaBeanSerializeUtil.deserialize((JavaBeanDescriptor)args[i]);
                            }
                        } else if (ProtocolUtils.isProtobufGenericSerialization(generic)) {
                            if (args.length == 1 && args[0] instanceof String) {
                                try (UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream(((String)args[0]).getBytes());){
                                    args[0] = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension("protobuf-json").deserialize(null, is).readObject(method.getParameterTypes()[0]);
                                    break block34;
                                }
                                catch (Exception e) {
                                    throw new RpcException("Deserialize argument failed.", (Throwable)e);
                                }
                            }
                            throw new RpcException("Generic serialization [protobuf-json] only support one " + String.class.getName() + " argument and your message size is " + args.length + " and type is" + args[0].getClass().getName());
                        }
                    }
                }
                RpcInvocation rpcInvocation = new RpcInvocation(method, invoker.getInterface().getName(), invoker.getUrl().getProtocolServiceKey(), args, inv.getObjectAttachments(), inv.getAttributes());
                rpcInvocation.setInvoker(inv.getInvoker());
                rpcInvocation.setTargetServiceUniqueName(inv.getTargetServiceUniqueName());
                return invoker.invoke(rpcInvocation);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RpcException(e.getMessage(), (Throwable)e);
            }
        }
        return invoker.invoke(inv);
    }

    private Object[] getGsonGenericArgs(Object[] args, Type[] types) {
        return IntStream.range(0, args.length).mapToObj(i -> {
            String str = "";
            str = args[i] instanceof Map ? gson.toJson(args[i]) : args[i].toString();
            if (types[i].equals(String.class)) {
                return str;
            }
            Type type = TypeToken.get((Type)types[i]).getType();
            try {
                return gson.fromJson(str, type);
            }
            catch (JsonSyntaxException ex) {
                throw new RpcException(String.format("Generic serialization [%s] Json syntax exception thrown when parsing (message:%s type:%s) error:%s", "youpin_json", str, type.toString(), ex.getMessage()));
            }
        }).toArray();
    }

    private Object[] getArgs(Object[] args, Method method, Object[] _args) {
        return IntStream.range(0, args.length).mapToObj(i -> {
            String arg = "";
            arg = _args[i] instanceof Map ? gson.toJson(_args[i]) : _args[i].toString();
            return ProtocolUtils.getObj(gson, arg, i, method);
        }).toArray(Object[]::new);
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation inv) {
        boolean raw = inv.getAttachment("mione_raw_return", "").equals("true");
        if ((inv.getMethodName().equals("$invoke") || inv.getMethodName().equals("$invokeAsync")) && inv.getArguments() != null && inv.getArguments().length == 3 && !GenericService.class.isAssignableFrom(invoker.getInterface())) {
            UnsafeByteArrayOutputStream os;
            String generic = inv.getAttachment("generic");
            if (StringUtils.isBlank(generic)) {
                generic = RpcContext.getContext().getAttachment("generic");
            }
            if (appResponse.hasException()) {
                Throwable appException = appResponse.getException();
                if (appException instanceof org.apache.dubbo.rpc.service.GenericException) {
                    org.apache.dubbo.rpc.service.GenericException tmp = (org.apache.dubbo.rpc.service.GenericException)appException;
                    appException = new GenericException(tmp.getExceptionClass(), tmp.getExceptionMessage());
                }
                if (!(appException instanceof GenericException)) {
                    appException = new GenericException(appException);
                }
                appResponse.setException(appException);
            }
            if (ProtocolUtils.isJavaGenericSerialization(generic)) {
                try {
                    os = new UnsafeByteArrayOutputStream(512);
                    ExtensionLoader.getExtensionLoader(Serialization.class).getExtension("nativejava").serialize(null, os).writeObject(appResponse.getValue());
                    appResponse.setValue(os.toByteArray());
                }
                catch (IOException e) {
                    throw new RpcException("Generic serialization [nativejava] serialize result failed.", (Throwable)e);
                }
            } else if (ProtocolUtils.isBeanGenericSerialization(generic)) {
                appResponse.setValue(JavaBeanSerializeUtil.serialize(appResponse.getValue(), JavaBeanAccessor.METHOD));
            } else if (ProtocolUtils.isProtobufGenericSerialization(generic)) {
                try {
                    os = new UnsafeByteArrayOutputStream(512);
                    ExtensionLoader.getExtensionLoader(Serialization.class).getExtension("protobuf-json").serialize(null, os).writeObject(appResponse.getValue());
                    appResponse.setValue(os.toString());
                }
                catch (IOException e) {
                    throw new RpcException("Generic serialization [protobuf-json] serialize result failed.", (Throwable)e);
                }
            } else {
                if (ProtocolUtils.isGenericReturnRawResult(generic)) {
                    return;
                }
                if (raw) {
                    appResponse.setValue(gson.toJson(appResponse.getValue()));
                } else {
                    appResponse.setValue(PojoUtils.generalize(appResponse.getValue()));
                }
            }
        }
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }
}

