/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.http;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.common.http.HttpRestResult;
import io.prometheus.client.Histogram;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class MetricsHttpAgent
implements HttpAgent {
    private HttpAgent httpAgent;

    public MetricsHttpAgent(HttpAgent httpAgent) {
        this.httpAgent = httpAgent;
    }

    @Override
    public void start() throws NacosException {
        this.httpAgent.start();
    }

    @Override
    public HttpSimpleClient.HttpResult httpGet(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        Histogram.Timer timer = MetricsMonitor.getConfigRequestMonitor("GET", path, "NA");
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.httpAgent.httpGet(path, headers, paramValues, encoding, readTimeoutMs);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            timer.observeDuration();
            timer.close();
        }
        return result;
    }

    @Override
    public HttpRestResult<String> httpGet(String path, Map<String, String> headers, Map<String, String> paramValues, String encode, long readTimeoutMs) throws Exception {
        HttpRestResult<String> result;
        Histogram.Timer timer = MetricsMonitor.getConfigRequestMonitor("GET", path, "NA");
        try {
            result = this.httpAgent.httpGet(path, headers, paramValues, encode, readTimeoutMs);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            timer.observeDuration();
        }
        return result;
    }

    @Override
    public HttpSimpleClient.HttpResult httpPost(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        Histogram.Timer timer = MetricsMonitor.getConfigRequestMonitor("POST", path, "NA");
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.httpAgent.httpPost(path, headers, paramValues, encoding, readTimeoutMs);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            timer.observeDuration();
            timer.close();
        }
        return result;
    }

    @Override
    public HttpRestResult<String> httpPost(String path, Map<String, String> headers, Map<String, String> paramValues, String encode, long readTimeoutMs) throws Exception {
        HttpRestResult<String> result;
        Histogram.Timer timer = MetricsMonitor.getConfigRequestMonitor("POST", path, "NA");
        try {
            result = this.httpAgent.httpPost(path, headers, paramValues, encode, readTimeoutMs);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            timer.observeDuration();
        }
        return result;
    }

    @Override
    public HttpSimpleClient.HttpResult httpDelete(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        Histogram.Timer timer = MetricsMonitor.getConfigRequestMonitor("DELETE", path, "NA");
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.httpAgent.httpDelete(path, headers, paramValues, encoding, readTimeoutMs);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            timer.observeDuration();
            timer.close();
        }
        return result;
    }

    @Override
    public String getName() {
        return this.httpAgent.getName();
    }

    @Override
    public String getNamespace() {
        return this.httpAgent.getNamespace();
    }

    @Override
    public String getTenant() {
        return this.httpAgent.getTenant();
    }

    @Override
    public String getEncode() {
        return this.httpAgent.getEncode();
    }
}

