/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.es.consumer;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.ozhera.trace.etl.api.service.MQExtension;
import org.apache.ozhera.trace.etl.bo.MqConfig;
import org.apache.ozhera.trace.etl.es.consumer.ConsumerService;
import org.apache.ozhera.trace.etl.es.util.pool.ConsumerPool;
import org.apache.ozhera.trace.etl.util.ThriftUtil;
import org.apache.ozhera.tspandata.TSpanData;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"mq.type"}, havingValue="kafka")
public class KafkaTraceSpanConsumer {
    private static final Logger log = LoggerFactory.getLogger(KafkaTraceSpanConsumer.class);
    @Value(value="${mq.consumer.group}")
    private String group;
    @NacosValue(value="${mq.nameseraddr}")
    private String nameSerAddr;
    @Value(value="${mq.es.topic}")
    private String topicName;
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private MQExtension mq;

    @PostConstruct
    public void takeMessage() throws MQClientException {
        MqConfig config = new MqConfig();
        config.setNameSerAddr(this.nameSerAddr);
        config.setConsumerGroup(this.group);
        config.setConsumerTopicName(this.topicName);
        config.setConsumerMethod(records -> {
            try {
                for (ConsumerRecord message : records) {
                    ConsumerPool.CONSUMER_POOL.submit(new ConsumerRunner(((String)message.value()).getBytes(StandardCharsets.ISO_8859_1)));
                    this.await();
                }
            }
            catch (Throwable t) {
                log.error("consumer message error", t);
            }
            return true;
        });
        this.mq.initMq(config);
    }

    private void await() {
        while (true) {
            try {
                while (true) {
                    if (ConsumerPool.CONSUMER_QUEUE.remainingCapacity() > 3000) {
                        return;
                    }
                    TimeUnit.MILLISECONDS.sleep(1L);
                }
            }
            catch (Throwable t) {
                log.error("await error : ", t);
                continue;
            }
            break;
        }
    }

    private class ConsumerRunner
    implements Runnable {
        private byte[] message;

        public ConsumerRunner(byte[] message) {
            this.message = message;
        }

        @Override
        public void run() {
            try {
                TSpanData tSpanData = new TSpanData();
                new TDeserializer(ThriftUtil.PROTOCOL_FACTORY).deserialize((TBase)tSpanData, this.message);
                KafkaTraceSpanConsumer.this.consumerService.consumer(tSpanData);
            }
            catch (Throwable t) {
                log.error("consumer error : ", t);
            }
        }
    }
}

