/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.model.UserInfo;
import org.apache.ozhera.monitor.service.user.LocalUser;
import org.apache.ozhera.monitor.service.user.UseDetailInfo;
import org.apache.ozhera.monitor.service.user.UserConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Autowired
    UserConfigService userConfigService;

    @ResponseBody
    @RequestMapping(value={"/user/info"})
    public Result userInfo(HttpServletRequest request) {
        try {
            AuthUserVo userVo = UserUtil.getUser();
            if (userVo == null) {
                log.info("UserController.userInfo request info error no user info found!");
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            UserInfo userInfo = new UserInfo();
            userInfo.setDepartmentName(userVo.getDepartmentName());
            userInfo.setDisplayName(userVo.getName());
            userInfo.setEmail(userVo.getEmail());
            userInfo.setName(userVo.getName());
            userInfo.setUser(userVo.genFullAccount());
            userInfo.setAvatar(userVo.getAvatarUrl());
            userInfo.setIsAdmin(Boolean.valueOf(this.userConfigService.isAdmin(userVo.genFullAccount())));
            Map depts = LocalUser.getDepts();
            UseDetailInfo.DeptDescr dept = depts == null ? null : (UseDetailInfo.DeptDescr)depts.get(1);
            UseDetailInfo.DeptDescr dept2 = depts == null ? null : (UseDetailInfo.DeptDescr)depts.get(2);
            userInfo.setFirstDepartment(dept == null ? null : dept.getDeptName());
            userInfo.setSecondDepartment(dept2 == null ? null : dept2.getDeptName());
            log.info("UserController.userInfo userInfo :{}", (Object)userInfo);
            return Result.success((Object)userInfo);
        }
        catch (Exception e) {
            log.error("UserController.addAlarmTemplate", (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }
}

