/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.utils;

import cn.hutool.core.util.HashUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);

    private ConfigUtils() {
    }

    public static String getConfigValue(String propertyKey) {
        String propertyValue = "";
        propertyValue = System.getenv(propertyKey);
        try {
            if (StringUtils.isBlank((CharSequence)propertyValue)) {
                propertyValue = System.getProperty(propertyKey);
            }
        }
        catch (Exception e) {
            log.error("get system param error,propertyKey:{}", (Object)propertyKey, (Object)e);
        }
        if (StringUtils.isBlank((CharSequence)propertyValue)) {
            propertyValue = Config.ins().get(propertyKey, "");
        }
        return propertyValue;
    }

    public static int getDataHashKey(String data, int max) {
        return Math.abs(HashUtil.apHash((String)data)) % max + 1;
    }
}

