/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.bind;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Objects;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.mapper.MilogLogTemplateMapper;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTemplateDO;
import org.apache.ozhera.log.manager.service.bind.LogTypeProcessor;
import org.apache.ozhera.log.manager.service.bind.Processor;

@Processor(isDefault=true, order=1000)
public class DataSourceLogTypeProcessor
implements LogTypeProcessor {
    private static final Integer EXIST_STATUS = 1;
    private final MilogLogTemplateMapper milogLogTemplateMapper;

    public DataSourceLogTypeProcessor(MilogLogTemplateMapper milogLogTemplateMapper) {
        this.milogLogTemplateMapper = milogLogTemplateMapper;
    }

    @Override
    public boolean supportedConsume(Integer logTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"type", (Object)logTypeCode);
        MilogLogTemplateDO templateDO = (MilogLogTemplateDO)this.milogLogTemplateMapper.selectOne((Wrapper)queryWrapper);
        if (null == templateDO) {
            throw new MilogManageException("log template not exist,logtypeType:" + logTypeCode);
        }
        return Objects.equals(EXIST_STATUS, templateDO.getSupportedConsume());
    }
}

