/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.es.EsService;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.domain.EsCluster;
import org.apache.ozhera.log.manager.domain.Tpc;
import org.apache.ozhera.log.manager.mapper.MilogLogCountMapper;
import org.apache.ozhera.log.manager.mapper.MilogLogstailMapper;
import org.apache.ozhera.log.manager.model.dto.LogtailCollectTopDTO;
import org.apache.ozhera.log.manager.model.dto.LogtailCollectTrendDTO;
import org.apache.ozhera.log.manager.model.dto.SpaceCollectTopDTO;
import org.apache.ozhera.log.manager.model.dto.SpaceCollectTrendDTO;
import org.apache.ozhera.log.manager.model.pojo.LogCountDO;
import org.apache.ozhera.log.manager.service.LogCountService;
import org.apache.ozhera.log.utils.DateUtils;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class LogCountServiceImpl
implements LogCountService {
    private static final Logger log = LoggerFactory.getLogger(LogCountServiceImpl.class);
    @Resource
    private MilogLogCountMapper logCountMapper;
    @Resource
    private MilogLogstailMapper logtailMapper;
    @Resource
    private EsCluster esCluster;
    @Resource
    private Tpc tpc;
    private List<LogtailCollectTopDTO> logtailCollectTopList = new ArrayList<LogtailCollectTopDTO>();
    private Map<String, Map<Long, List<LogtailCollectTrendDTO>>> logtailCollectTrendMap = new HashMap<String, Map<Long, List<LogtailCollectTrendDTO>>>();
    private List<SpaceCollectTopDTO> spaceCollectTopList = new ArrayList<SpaceCollectTopDTO>();
    private Map<Long, List<SpaceCollectTrendDTO>> spaceCollectTrendCache = new HashMap<Long, List<SpaceCollectTrendDTO>>();

    @Override
    public Result<List<LogtailCollectTopDTO>> collectTop() {
        return Result.success(this.logtailCollectTopList);
    }

    @Override
    public Result<List<LogtailCollectTrendDTO>> collectTrend(Long tailId) {
        String thisDay = DateUtils.getDaysAgo((int)1);
        if (!this.logtailCollectTrendMap.containsKey(thisDay) || !this.logtailCollectTrendMap.get(thisDay).containsKey(tailId)) {
            this.collectTrendCount(tailId);
        }
        return Result.success(this.logtailCollectTrendMap.get(thisDay).get(tailId));
    }

    @Override
    public void collectTopCount() {
        List<Map<String, Object>> res = this.logCountMapper.collectTopCount(DateUtils.getDaysAgo((int)7), DateUtils.getDaysAgo((int)1));
        ArrayList<LogtailCollectTopDTO> dtoList = new ArrayList<LogtailCollectTopDTO>();
        for (Map<String, Object> count : res) {
            LogtailCollectTopDTO dto = new LogtailCollectTopDTO();
            dto.setTail(String.valueOf(count.get("tail")));
            dto.setNumber(this.getLogNumberFormat(Long.parseLong(count.get("number").toString())));
            dtoList.add(dto);
        }
        this.logtailCollectTopList = dtoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectTrendCount(Long tailId) {
        String yesterday = DateUtils.getDaysAgo((int)1);
        Object object = this;
        synchronized (object) {
            if (this.logtailCollectTrendMap.containsKey(yesterday) && this.logtailCollectTrendMap.get(yesterday).containsKey(tailId)) {
                return;
            }
            if (!this.logtailCollectTrendMap.containsKey(yesterday)) {
                this.logtailCollectTrendMap.remove(DateUtils.getDaysAgo((int)2));
                this.logtailCollectTrendMap.put(yesterday, new HashMap());
            }
        }
        object = tailId;
        synchronized (object) {
            if (this.logtailCollectTrendMap.get(yesterday).containsKey(tailId)) {
                return;
            }
            List<Map<String, Object>> resList = this.logCountMapper.collectTrend(DateUtils.getDaysAgo((int)7), DateUtils.getDaysAgo((int)1), tailId);
            ArrayList<LogtailCollectTrendDTO> trendlist = new ArrayList<LogtailCollectTrendDTO>();
            for (Map<String, Object> res : resList) {
                LogtailCollectTrendDTO dto = new LogtailCollectTrendDTO();
                dto.setDay(String.valueOf(res.get("day")).split("-")[2] + "day");
                dto.setNumber(String.valueOf(res.get("number")));
                dto.setShowNumber(this.getLogNumberFormat(Long.parseLong(String.valueOf(res.get("number")))));
                trendlist.add(dto);
            }
            this.logtailCollectTrendMap.get(yesterday).put(tailId, trendlist);
        }
    }

    @Override
    public void collectLogCount(String thisDay) throws IOException {
        log.info("Statistics log starts");
        this.logCountMapper.deleteThisDay(thisDay);
        if (StringUtils.isEmpty((String)thisDay)) {
            thisDay = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        }
        Long thisDayFirstMillisecond = DateUtils.getThisDayFirstMillisecond((String)thisDay);
        ArrayList<LogCountDO> logCountDOList = new ArrayList<LogCountDO>();
        List<Map<String, Object>> tailList = this.logtailMapper.getAllTailForCount();
        for (Map<String, Object> tail : tailList) {
            try {
                Long total;
                String esIndex = String.valueOf(tail.get("es_index"));
                if (StringUtils.isEmpty((String)esIndex) || tail.get("es_cluster_id") == null) {
                    total = 0L;
                    esIndex = "";
                } else {
                    EsService esService = this.esCluster.getEsService(Long.parseLong(String.valueOf(tail.get("es_cluster_id"))));
                    if (esService == null) {
                        log.warn("Statistics logs warn,tail:{} the logs are not counted and the ES client is not generated", tail);
                        continue;
                    }
                    SearchSourceBuilder builder = new SearchSourceBuilder();
                    BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
                    boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"tail", (Object)tail.get("tail")));
                    boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").from((Object)thisDayFirstMillisecond).to((Object)(thisDayFirstMillisecond + DateUtils.dayms - 1L)));
                    builder.query((QueryBuilder)boolQueryBuilder);
                    CountRequest countRequest = new CountRequest();
                    countRequest.indices(new String[]{esIndex});
                    countRequest.source(builder);
                    total = esService.count(countRequest);
                }
                LogCountDO logCountDO = new LogCountDO();
                logCountDO.setTailId(Long.parseLong(String.valueOf(tail.get("id"))));
                logCountDO.setEsIndex(esIndex);
                logCountDO.setNumber(total);
                logCountDO.setDay(thisDay);
                logCountDOList.add(logCountDO);
            }
            catch (Exception e) {
                log.error("collectLogCount error,thisDay:{}", (Object)thisDay, (Object)e);
            }
        }
        long res = 0L;
        if (CollectionUtils.isNotEmpty(logCountDOList)) {
            res = this.logCountMapper.batchInsert(logCountDOList);
        }
        log.info("End of statistics log,Should be counted{}\uff0cTotal statistics{}", (Object)tailList.size(), (Object)res);
    }

    @Override
    public boolean isLogtailCountDone(String day) {
        Long logTailCountDone = this.logCountMapper.isLogtailCountDone(day);
        return !Objects.equals(logTailCountDone, 0L);
    }

    @Override
    public void deleteHistoryLogCount() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -70);
        String deleteBeforedDay = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        this.logCountMapper.deleteBeforeDay(deleteBeforedDay);
    }

    @Override
    public void collectLogDelete(String day) {
        this.logCountMapper.deleteThisDay(day);
    }

    @Override
    public void collectTrendRefresh() {
        this.logtailCollectTrendMap.clear();
    }

    private String getLogNumberFormat(long number) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(2);
        format.setMinimumFractionDigits(2);
        if (number >= 100000000L) {
            return format.format((float)number / 1.0E8f) + "hundred million";
        }
        if (number >= 1000000L) {
            return format.format((float)number / 1000000.0f) + "million";
        }
        if (number >= 10000L) {
            return format.format((float)number / 10000.0f) + "ten thousand";
        }
        return number + "strip";
    }

    @Override
    public void showLogCountCache() {
        log.info("logTopList:{}", this.logtailCollectTopList);
        log.info("logTrendMap:{}", this.logtailCollectTrendMap);
    }

    @Override
    public Result<List<SpaceCollectTopDTO>> collectSpaceTop() {
        return Result.success(this.spaceCollectTopList);
    }

    @Override
    public void collectSpaceTopCount() {
        List<Map<String, Object>> spaceTopList = this.logCountMapper.collectSpaceCount(DateUtils.getDaysAgo((int)7), DateUtils.getDaysAgo((int)1));
        ArrayList<SpaceCollectTopDTO> dtoList = new ArrayList<SpaceCollectTopDTO>();
        for (Map<String, Object> spaceTop : spaceTopList) {
            SpaceCollectTopDTO dto = new SpaceCollectTopDTO();
            dto.setSpaceName(String.valueOf(spaceTop.get("spaceName")));
            dto.setNumber(this.getLogNumberFormat(Long.parseLong(spaceTop.get("number").toString())));
            dto.setOrgName(this.tpc.getSpaceLastOrg(Long.parseLong(String.valueOf(spaceTop.get("spaceId")))));
            dtoList.add(dto);
        }
        this.spaceCollectTopList = dtoList;
    }

    @Override
    public void collectSpaceTrend() {
        List<Map<String, Object>> spaceTrendList = this.logCountMapper.collectSpaceTrend(DateUtils.getDaysAgo((int)7), DateUtils.getDaysAgo((int)1));
        if (CollectionUtils.isEmpty(spaceTrendList)) {
            return;
        }
        HashMap<Long, List<SpaceCollectTrendDTO>> cache = new HashMap<Long, List<SpaceCollectTrendDTO>>();
        ArrayList<SpaceCollectTrendDTO> dtoList = new ArrayList<SpaceCollectTrendDTO>();
        Long lastSpaceId = Long.parseLong(String.valueOf(spaceTrendList.get(0).get("spaceId")));
        for (Map<String, Object> spaceTrend : spaceTrendList) {
            Long thisSpaceId = Long.parseLong(String.valueOf(spaceTrend.get("spaceId")));
            if (!thisSpaceId.equals(lastSpaceId)) {
                cache.put(lastSpaceId, dtoList);
                dtoList = new ArrayList();
            }
            SpaceCollectTrendDTO dto = new SpaceCollectTrendDTO();
            dto.setSpaceName(String.valueOf(spaceTrend.get("spaceName")));
            dto.setNumber(String.valueOf(spaceTrend.get("number")));
            dto.setShowNumber(this.getLogNumberFormat(Long.parseLong(String.valueOf(spaceTrend.get("number")))));
            dto.setOrgName(this.tpc.getSpaceLastOrg(Long.parseLong(String.valueOf(spaceTrend.get("spaceId")))));
            dto.setDay(String.valueOf(spaceTrend.get("day")).split("-")[2] + "day");
            dtoList.add(dto);
            lastSpaceId = thisSpaceId;
        }
        this.spaceCollectTrendCache = cache;
    }

    @Override
    public Result<List<SpaceCollectTrendDTO>> spaceCollectTrend(Long spaceId) {
        return Result.success(this.spaceCollectTrendCache.get(spaceId));
    }
}

