/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.nacos.impl;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.nacos.DynamicConfigPublisher;
import org.apache.ozhera.log.model.MilogSpaceData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceConfigNacosPublisher
implements DynamicConfigPublisher<MilogSpaceData> {
    private static final Logger log = LoggerFactory.getLogger(SpaceConfigNacosPublisher.class);
    private ConfigService configService;

    @Override
    public void publish(Long uniqueSpace, MilogSpaceData config) {
        log.info("write the creation namespace configuration:{}", (Object)gson.toJson((Object)config));
        String dataId = CommonExtensionServiceFactory.getCommonExtensionService().getLogManagePrefix() + "create_tail_config:" + uniqueSpace;
        try {
            this.configService.publishConfig(dataId, "DEFAULT_GROUP", gson.toJson((Object)config));
        }
        catch (NacosException e) {
            log.error(String.format("Write the creation namespace configuration...,dataId:{},data:%s", dataId, gson.toJson((Object)config)), (Throwable)e);
        }
    }

    @Override
    public void remove(String spaceId) {
        String dataId = CommonExtensionServiceFactory.getCommonExtensionService().getLogManagePrefix() + "create_tail_config:" + spaceId;
        try {
            this.configService.removeConfig(dataId, "DEFAULT_GROUP");
        }
        catch (NacosException e) {
            log.error(String.format("Delete log configuration data data exceptions,param\uff1a%s", dataId), (Throwable)e);
        }
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }
}

