/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.manager.controller;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.youpin.infra.rpc.Result;
import com.xiaomi.youpin.infra.rpc.errors.ErrorCode;
import com.xiaomi.youpin.infra.rpc.errors.GeneralCodes;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.trace.etl.domain.HeraTraceConfigVo;
import org.apache.ozhera.trace.etl.domain.HeraTraceEtlConfig;
import org.apache.ozhera.trace.etl.domain.PagerVo;
import org.apache.ozhera.trace.etl.service.ManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ManagerController {
    private static final Logger log = LoggerFactory.getLogger(ManagerController.class);
    @NacosValue(value="${hera.admin.member.list}")
    public String adminMemList;
    @Autowired
    private ManagerService managerService;

    @GetMapping(value={"/manager/getAllPage"})
    public Object getAllPage(HeraTraceConfigVo vo, HttpServletRequest request) {
        try {
            AuthUserVo user = UserUtil.getUser();
            if (user == null || StringUtils.isEmpty((CharSequence)user.genFullAccount())) {
                log.warn("getAllPage userInfo is null");
                return Result.fail((ErrorCode)GeneralCodes.InternalError, (String)"The user information is empty. Please log in again");
            }
            String userName = user.genFullAccount();
            log.info("userName is : " + userName);
            if (!this.isAdmin(userName)) {
                vo.setUser(userName);
            }
            this.initPage((PagerVo)vo);
            return Result.success((Object)this.managerService.getAllPage(vo));
        }
        catch (Exception e) {
            log.error("get all page error : ", (Throwable)e);
            return Result.fromException((Throwable)e);
        }
    }

    private boolean isAdmin(String user) {
        String[] split;
        if (StringUtils.isEmpty((CharSequence)this.adminMemList)) {
            return false;
        }
        for (String adminMem : split = this.adminMemList.split(",")) {
            if (!user.equals(adminMem)) continue;
            return true;
        }
        return false;
    }

    @GetMapping(value={"/manager/getAllList"})
    public Object getAllList(HeraTraceConfigVo vo) {
        try {
            return Result.success((Object)this.managerService.getAll(vo));
        }
        catch (Exception e) {
            log.error("get all list error : ", (Throwable)e);
            return Result.fromException((Throwable)e);
        }
    }

    @GetMapping(value={"/manager/getDetail"})
    public Object getDetail(Integer id) {
        try {
            log.info("getDetail param : " + id);
            return Result.success((Object)this.managerService.getById(id));
        }
        catch (Exception e) {
            log.error("get all list error : ", (Throwable)e);
            return Result.fromException((Throwable)e);
        }
    }

    @PostMapping(value={"/manager/insertOrUpdate"})
    public Object insertOrUpdate(HeraTraceEtlConfig config, HttpServletRequest request) {
        try {
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.warn("insertOrUpdate userInfo is null");
                return Result.fail((ErrorCode)GeneralCodes.InternalError, (String)"The user information is empty. Please log in again");
            }
            String user = userInfo.genFullAccount();
            log.info("insertOrUpdate user : " + user + " param : " + String.valueOf(config));
            return this.managerService.insertOrUpdate(config, null);
        }
        catch (Exception e) {
            log.error("insert or update error : ", (Throwable)e);
            return Result.fromException((Throwable)e);
        }
    }

    @PostMapping(value={"/manager/delete"})
    public Object delete(HeraTraceEtlConfig config) {
        try {
            log.info("delete param : " + String.valueOf(config));
            int delete = this.managerService.delete(config);
            return delete > 0 ? Result.success(null) : Result.fail((ErrorCode)GeneralCodes.InternalError, (String)"Deletion failure");
        }
        catch (Exception e) {
            log.error("delete error : ", (Throwable)e);
            return Result.fromException((Throwable)e);
        }
    }

    private void initPage(PagerVo vo) {
        if (vo.getPageSize() == null) {
            vo.setPageSize(10000);
        }
    }
}

