/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.manager.filter;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeaderFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(RequestHeaderFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        this.printHeaders(request);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        super.destroy();
    }

    private void printHeaders(HttpServletRequest request) {
        String uri = request.getRequestURI();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames == null || !headerNames.hasMoreElements()) {
            log.info(uri + " : request header is null");
        } else {
            log.info(uri + " : request header start ===================");
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                log.info(headerName + " : " + request.getHeader(headerName));
            }
            log.info(uri + " : request header end ===================");
        }
    }
}

