/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.mapper.AlertManagerRulesMapper;
import org.apache.ozhera.monitor.dao.model.AlertManagerRules;
import org.apache.ozhera.monitor.dao.model.AlertManagerRulesExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AlertManagerRulesDao {
    private static final Logger log = LoggerFactory.getLogger(AlertManagerRulesDao.class);
    @Autowired
    private AlertManagerRulesMapper alertManagerRulesMapper;

    public int insertAlert(AlertManagerRules alertManagerRules) {
        alertManagerRules.setCreateTime(new Date());
        alertManagerRules.setUpdateTime(new Date());
        try {
            int result = this.alertManagerRulesMapper.insert(alertManagerRules);
            if (result < 0) {
                log.warn("[AlertManagerRulesDao.insert] failed to insert AlertManagerRulesMapper: {}", (Object)alertManagerRules.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AlertManagerRulesDao.insert] failed to insert AlertManagerRulesMapper: {}, err: {}", (Object)alertManagerRules.toString(), (Object)e);
            return 0;
        }
        return 1;
    }

    public String[] getPrincipal(String alertName) {
        AlertManagerRulesExample example = new AlertManagerRulesExample();
        example.createCriteria().andRuleAlertEqualTo(alertName);
        List<AlertManagerRules> alertManagerRules = this.alertManagerRulesMapper.selectByExample(example);
        for (AlertManagerRules amr : alertManagerRules) {
            String tmpPrincipals = amr.getPrincipal();
            if (!StringUtils.isNotEmpty((CharSequence)tmpPrincipals)) continue;
            return tmpPrincipals.split(",");
        }
        return new String[0];
    }
}

